(function($) {

    $.su = $.su || {};
    $.su.CHAR = $.su.CHAR || {};
    $.su.CHAR.HELP = {
        STATUS_INTERNET: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mostra informações relevantes sobre a ligação WAN Wide Área Network (Internet)."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "O endereço físico atribuído à porta de Internet (WAN) do router."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Endereço IP atribuído à porta de Internet (WAN) do router. Se for exibido o endereço IP como 0.0.0.0, indica que não existe ligação à Internet."
                }, {
                    type: "name",
                    title: "Máscara de Rede",
                    content: "Este parâmetro determina a parte da rede e a parte do anfitrião de um endereço IP."
                }, {
                    type: "name",
                    title: "Gateway Padrão",
                    content: "Endereço IP utilizado para conectar e encaminhar o tráfego externo à rede local do Router para a Internet."
                }, {
                    type: "name",
                    title: "DNS Primário/DNS Secundário",
                    content: "O Domain Name System (DNS) traduz nomes de dispositivos e domínios de internet em endereços IP. As informações desses servidores DNS são atribuídas pelo fornecedor de serviços de Internet (ISP)."
                }, {
                    type: "name",
                    title: "Tipo Ligação",
                    content: "Tipo de ligação atual da porta Internet (WAN)."
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Endereço físico exclusivo atribuído à porta de Internet (WAN) do router."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Endereço IP atribuído à porta de Internet (WAN) do router."
                }, {
                    type: "name",
                    title: "Gateway Padrão",
                    content: "Endereço IP utilizado para conectar e encaminhar o tráfego externo à rede local do Router para a Internet."
                }, {
                    type: "name",
                    title: "DNS Primário/DNS Secundário",
                    content: "O Domain Name System (DNS) traduz nomes de dispositivos e domínios de internet em endereços IP. As informações desses servidores DNS são atribuídas pelo fornecedor de serviços de Internet (ISP)."
                }, {
                    type: "name",
                    title: "Tipo Ligação",
                    content: "Tipo de ligação atual da porta Internet (WAN)."
                }
            ]
        },
        STATUS_PLC_NTW: {
            TITLE: "Rede Powerline",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Clique no ícone Powerline Network para exibir a lista de todos os dispositivos Powerline na rede atual."
                }
            ]
        },
        STATUS_PLC: {
            TITLE: "Powerline",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Clique no ícone Powerline para exibir as informações detalhadas do extensor Powerline local."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "O identificador exclusivo que é atribuído ao extensor de linha de alimentação."
                }, {
                    type: "name",
                    title: "Senha Powerline",
                    content: "Chave única do dispositivo Powerline que é usada quando está adicionar à rede Powerline existente. A chave também está impressa na etiqueta do produto."
                }, {
                    type: "name",
                    title: "Nome da Rede",
                    content: "O nome da rede em que o dispositivo Powerline está instalado. O nome padrão é HomePlugAV."
                }
            ]
        },
        STATUS_WIRELESS: {
            TITLE: "Rede Wi-Fi 2.4GHz<span class=\"anti_5g\">/5GHz</span> ",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Apresenta o estado e as informações básicas da Rede Wireless (Wi-Fi)."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Estado atual (Ligado ou Desligado) da sua Rede Wireless (Wi-Fi)."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Service Set Identifier (SSID), também conhecido como nome de Rede Wireless (Wi-Fi)."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Canal de rádio Wi-Fi atual."
                }, {
                    type: "name",
                    title: "MAC",
                    content: "Endereço MAC do modulo Wi-Fi do Powerline."
                }
            ]
        },
        STATUS_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Apresenta informações sobre as portas Ethernet (LAN)."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Endereço físico exclusivo atribuído à porta Ethernet (LAN) do router."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Endereço IPv4 assignado à porta Ethernet (LAN) do router."
                }, {
                    type: "name",
                    title: "Máscara de Rede",
                    content: "Este parâmetro determina a parte da rede e a parte do anfitrião de um endereço IP."
                }, {
                    type: "name",
                    title: "DHCP",
                    content: "Apresenta se o servidor interno DHCP do router está ativo para os dispositivos ligados nas portas LAN."
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Endereço físico exclusivo atribuído à porta Ethernet (LAN) do router."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Endereço IPv6 atribuído à porta Internet (LAN) do router."
                }, {
                    type: "name",
                    title: "Endereço Ligação-local",
                    content: "O endereço da ligação IPv6 para o interface LAN."
                }, {
                    type: "name",
                    title: "Tipo de Atribuição",
                    content: "Tipo de endereço IPv6 para o interface LAN."
                }
            ]
        },
        STATUS_GUEST: {
            TITLE: "Rede de Convidados 2.4GHz<span class=\"anti_5g\">/5GHz</span> ",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mostra informações sobre a Rede Wi-Fi para Convidados."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Apresenta o estado atual (Ativado ou Desativado) da Rede de convidados."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Nome da rede Wi-Fi para a Rede de Convidados."
                }
            ]
        },
        STATUS_USB: {
            TITLE: "Dispositivos USB",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mostra informações dos dispositivos de armazenamento e / ou impressoras USB atualmente ligados ao router através das portas USB."
                }, {
                    type: "name",
                    title: "Impressora",
                    content: "Nome da impressora conectada."
                }, {
                    type: "name",
                    title: "Total",
                    content: "A capacidade de armazenamento total do dispositivo de armazenamento USB conectado."
                }, {
                    type: "name",
                    title: "Disponível",
                    content: "A capacidade de armazenamento disponível no dispositivo de armazenamento USB conectado."
                }
            ]
        },
        STATUS_PERFORMANCE: {
            TITLE: "Performance",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mostra o atual desempenho do router."
                }, {
                    type: "name",
                    title: "Carga de CPU",
                    content: "Atual uso do CPU."
                }, {
                    type: "name",
                    title: "Utilização de memória",
                    content: "Memória atualmente em uso."
                }
            ]
        },
        STATUS_WIRED: {
            TITLE: "Clientes LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mostra informações de todos os dispositivos ligados por cabo que estão conectados à rede."
                }
            ]
        },
        STATUS_WIRELESS_CLIENTS: {
            TITLE: "Clientes Wi-Fi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Clique no ícone Clientes Wireless para exibir as informações de todos os dispositivos Wi-Fi que estão atualmente ligados à rede Wireless do Powerline."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Endereço MAC Wi-Fi do dispositivo ligado."
                }, {
                    type: "name",
                    title: "Banda Wireless",
                    content: "Banda Wi-Fi <span class=\"anti_5g\">(2.4GHz ou 5GHz) </span>que o cliente está ligado."
                }
            ]
        },
        STATUS_WIFI_MOVE: {
            TITLE: "Wi-Fi Move",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Indica se a função Wi-Fi Move está ativa."
                }
            ]
        },
        INTERNET_INTERNET: {
            TITLE: "IPv4",
            CONTENT: [
                {
                    type: "title",
                    title: "Tipo de Ligação de Internet: IP Estático"
                }, {
                    type: "paragraph",
                    content: "Selecione este tipo de ligação se o seu ISP lhe forneceu Endereço IP, Máscara de Rede, Gateway Predefinido, DNS Primário e DNS Secundário específicos (fixos)."
                }, {
                    type: "name",
                    title: "Endereço IP/Máscara de Sub-rede/Gateway Padrão/DNS Primário/DNS Secundário",
                    content: "Digite as informações fornecidas pelo seu ISP."
                }, {
                    type: "name",
                    title: "Tamanho MTU",
                    content: "O valor MTU  (Maximum Transmission Unit) típico e predefinido para a maioria das redes Ethernet é 1500 Bytes. Não é recomendado alterar o tamanho MTU predefinido, a menos que exigido pelo ISP."
                }, {
                    type: "title",
                    title: "Tipo de Ligação de Internet: IP dinâmico"
                }, {
                    type: "paragraph",
                    content: "Selecione este tipo de serviço DHCP, caso o seu ISP (Internet Service Provider) atribua uma ligação Servidor DHCP."
                }, {
                    type: "name",
                    title: "Endereço IP/Máscara de Sub-rede/Gateway Padrão/DNS Primário/DNS Secundário",
                    content: "Estes parâmetros são fornecidos automaticamente pelo servidor DHCP do seu ISP."
                }, {
                    type: "name",
                    title: "Renovar",
                    content: "Clique neste botão para obter novos parâmetros IP do servidor DHCP do seu ISP."
                }, {
                    type: "name",
                    title: "Libertar",
                    content: "Clique neste botão para liberar todos os endereços IP atribuídos pelo servidor DHCP."
                }, {
                    type: "name",
                    title: "Utilizar o seguinte endereço DNS",
                    content: "Se o seu ISP fornece um ou dois endereços de DNS, selecione esta opção e introduza os endereços de DNS Primário e Secundário nos campos correspondentes; de outro modo, os endereços de DNS serão atribuídos dinamicamente pelo seu ISP."
                }, {
                    type: "name",
                    title: "Tamanho MTU",
                    content: "O valor MTU  (Maximum Transmission Unit) típico e predefinido para a maioria das redes Ethernet é 1500 Bytes. Não é recomendado alterar o tamanho MTU predefinido, a menos que exigido pelo ISP."
                }, {
                    type: "name",
                    title: "Node do Host",
                    content: "Digite um valor para este campo para especificar o nome do Router."
                }, {
                    type: "name",
                    title: "Obter IP usando Unicast DHCP",
                    content: "Selecione esta opção se o servidor de DHCP do seu ISP não suportar aplicações de Broadcast e não conseguir obter o endereço IP dinamicamente."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Se for apresentado o erro \"Endereço não encontrado\" depois de inserir os endereços DNS, é provável que seus servidores DNS estejam configurados incorretamente; por favor verifique junto do ISP os endereços corretos."
                }, {
                    type: "title",
                    title: "Tipo de Ligação à Internet: PPPoE"
                }, {
                    type: "paragraph",
                    content: "Selecione este tipo de ligação se usar o serviço DSL (Digital Subscriber Line) e o seu ISP fornece nome de utilizador e senha."
                }, {
                    type: "name",
                    title: "Utilizador/Senha",
                    content: "Digite o nome de utilizador e senha fornecidos pelo seu ISP. Estes campos são sensíveis a caracteres em maiúsculas e minúsculas."
                }, {
                    type: "name",
                    title: "Endereço IP da Internet/DNS primário/DNS secundário",
                    content: "Estes parâmetros são fornecidos automaticamente pelo servidor DHCP do seu ISP."
                }, {
                    type: "name",
                    title: "Ligação Secundária (Nenhum, IP Dinâmico, IP Estático)",
                    children: [
                        {
                            type: "name",
                            title: "Nenhum",
                            content: "Selecione se não existir ligação secundária"
                        }, {
                            type: "name",
                            title: "IP Dinâmico",
                            content: "Selecione se o endereço IP e Máscara de Rede são atribuídos automaticamente pelo ISP.",
                            children: [
                                {
                                    type: "name",
                                    title: "Renovar",
                                    content: "Clique neste botão para obter novos parâmetros IP do servidor DHCP do seu ISP."
                                }, {
                                    type: "name",
                                    title: "Libertar",
                                    content: "Clique neste botão para liberar todos os endereços IP atribuídos pelo servidor DHCP."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "IP Estático",
                            content: "Selecione se os endereços IP, Máscara de Rede, Gateway e DNS  são fornecidos pelo ISP e insira essas informações nos campos correspondentes."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Tamanho MTU",
                    content: "O valor MTU  (Maximum Transmission Unit) típico para redes Ethernet é 1480 Bytes.",
                    children: [
                        {
                            type: "note",
                            title: "Nota",
                            content: "Nota: Em casos raros, o seu ISP pode exigir que ajuste o valor de  MTU para um melhor desempenho da rede. Não deve alterar o valor, a menos que seja absolutamente necessário."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Nome do Serviço/Nome do Concentrador de Acesso",
                    content: "Por defeito, o Nome de Serviço  e Nome de Concentrador de Acesso (AC) são deixados em branco. Estes campos não devem ser configurados exceto se exigido por seu ISP."
                }, {
                    type: "name",
                    title: "Intervalo deteção Online",
                    content: "Introduza o valor de intervalo de tempo entre 0 e 120 (em segundos) para o qual o router deteta o Concentrador de Acesso online a cada intervalo. O valor padrão é 0, significando que não há deteção."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Se o seu ISP fornece um endereço IP específico (fixo), selecione Usar o seguinte Endereço IP e digite o endereço IP no campo disponível; Caso contrário, selecione Obter dinamicamente do seu ISP, para obter um endereço IP automaticamente."
                }, {
                    type: "name",
                    title: "Endereço DNS/DNS primário/DNS secundário",
                    content: "Se o seu ISP fornecer os endereços DNS específicos (fixos), selecione Usar o seguinte endereço DNS e insira o(s) endereço(s) nos campos DNS primário e DNS secundário; Caso contrário, selecione Obter dinamicamente através do seu ISP para obter automaticamente os endereços de DNS."
                }, {
                    type: "name",
                    title: "Modo Ligação",
                    content: "Selecione modo de ligação apropriado que determina como se conectar à Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "Neste modo, a ligação à Internet é restabelecida automaticamente assim que é desconectada."
                        }, {
                            type: "name",
                            title: "On Demand",
                            content: "Neste modo, a ligação à Internet será encerrada automaticamente após ter decorrido um determinado tempo de inatividade (Tempo Máximo de Inatividade). A ligação é restabelecida quando tentar aceder novamente a Internet."
                        }, {
                            type: "name",
                            title: "Time-Based",
                            content: "Neste modo, a ligação à Internet é estabelecida apenas num período de tempo específico. Se essa opção for selecionada, digite o tempo de início e fim, ambos no formato HH: MM."
                        }, {
                            type: "name",
                            title: "Manual",
                            content: "Neste modo, a ligação à Internet é controlada manualmente clicando no botão Ligar ou Desligar. Este modo também suporta a função Max Idle Time. Insira um tempo máximo (em minutos) a ligação à Internet pode estar inativa antes de ser encerrada no campo Tempo de inatividade máximo. Por defeito o valor é de 15 minutos. Se pretender que a ligação à Internet permaneça sempre ativa, digite 0 (zero)."
                        }, {
                            type: "note",
                            title: "Nota",
                            content: "Nota: O modo de ligação Agendado só terá efeito se for configurar o relógio de sistema em Ferramentas de Sistema → Sistema → Definições de Tempo."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Tipo de conexão de Internet: Cabo BigPond"
                }, {
                    type: "paragraph",
                    content: "Selecione este tipo se o seu ISP fornece ligação Bigpond Cable."
                }, {
                    type: "name",
                    title: "Utilizador/Senha",
                    content: "Digite o nome de utilizador e senha fornecidos pelo seu ISP. Estes campos são sensíveis a caracteres em maiúsculas e minúsculas."
                }, {
                    type: "name",
                    title: "Servidor Auten.",
                    content: "Introduza o endereço IP ou o nome do servidor de autenticação."
                }, {
                    type: "name",
                    title: "Domínio Auten.",
                    content: "Digite o sufixo do nome de domínio do servidor (baseado na sua localização). Por exemplo, nsw.bigpond.net.au para NSW/ACT, vic.bigpond.net.au para VIC/TAS/WA/SA/NT, ou qld.bigpond.net.au para QLD."
                }, {
                    type: "name",
                    title: "Tamanho MTU",
                    content: "O valor MTU  (Maximum Transmission Unit) típico e predefinido para a maioria das redes Ethernet é 1500 Bytes. Não é recomendado alterar o tamanho MTU predefinido, a menos que exigido pelo ISP."
                }, {
                    type: "name",
                    title: "Modo Ligação",
                    content: "Selecione modo de ligação apropriado que determina como se conectar à Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "Neste modo, a ligação à Internet é restabelecida automaticamente assim que é desconectada."
                        }, {
                            type: "name",
                            title: "On Demand",
                            content: "Neste modo, a ligação à Internet será encerrada automaticamente após ter decorrido um determinado tempo de inatividade (Tempo Máximo de Inatividade). A ligação é restabelecida quando tentar aceder novamente a Internet."
                        }, {
                            type: "name",
                            title: "Manual",
                            content: "Neste modo, a ligação à Internet é controlada manualmente clicando no botão Ligar ou Desligar. Este modo também suporta a função Max Idle Time. Insira um tempo máximo (em minutos) a ligação à Internet pode estar inativa antes de ser encerrada no campo Tempo de inatividade máximo. Por defeito o valor é de 15 minutos. Se pretender que a ligação à Internet permaneça sempre ativa, digite 0 (zero)."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Tipo de Ligação à Internet: L2TP/PPTP"
                }, {
                    type: "paragraph",
                    content: "Selecione este tipo se ligar a um servidor VPN L2TP/ PPTP e são fornecidos pelo ISP o nome de utilizador, senha e endereço de IP / Nome de Domínio do servidor."
                }, {
                    type: "name",
                    title: "Utilizador/Senha",
                    content: "Digite o nome de utilizador e senha fornecidos pelo seu ISP. Estes campos são sensíveis a caracteres em maiúsculas e minúsculas."
                }, {
                    type: "name",
                    title: "Endereço IP da Internet/DNS primário/DNS secundário",
                    content: "Estes parâmetros são fornecidos automaticamente pelo servidor DHCP do seu ISP."
                }, {
                    type: "name",
                    title: "Ligação Secundária (IP Dinâmico ou IP Estático)",
                    children: [
                        {
                            type: "name",
                            title: "IP Dinâmico",
                            content: "Selecione se o endereço IP e Máscara de Rede são atribuídos automaticamente pelo ISP.",
                            children: [
                                {
                                    type: "name",
                                    title: "Renovar",
                                    content: "Clique neste botão para obter novos parâmetros IP do servidor DHCP do seu ISP."
                                }, {
                                    type: "name",
                                    title: "Libertar",
                                    content: "Clique neste botão para liberar todos os endereços IP atribuídos pelo servidor DHCP."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "IP Estático",
                            content: "Selecione se os endereços IP, Máscara de Rede, Gateway e DNS  são fornecidos pelo ISP e insira essas informações nos campos correspondentes."
                        }
                    ]
                }, {
                    type: "name",
                    title: "IP/Nome de Domínio do Servidor VPN",
                    content: "Introduza o endereço IP ou o nome de domínio do servidor VPN fornecidos pelo seu ISP."
                }, {
                    type: "name",
                    title: "Tamanho MTU",
                    content: "O tamanho padrão de MTU (Maximum Transmission Unit) para a maioria das redes Ethernet é 1460 Bytes. Não é recomendado alterar o tamanho padrão de MTU, salvo indicação contrária do seu ISP."
                }, {
                    type: "name",
                    title: "Modo Ligação",
                    content: "Selecione modo de ligação apropriado que determina como se conectar à Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "Neste modo, a ligação à Internet é restabelecida automaticamente assim que é desconectada."
                        }, {
                            type: "name",
                            title: "On Demand",
                            content: "Neste modo, a ligação à Internet será encerrada automaticamente após ter decorrido um determinado tempo de inatividade (Tempo Máximo de Inatividade). A ligação é restabelecida quando tentar aceder novamente a Internet."
                        }, {
                            type: "name",
                            title: "Manual",
                            content: "Neste modo, a ligação à Internet é controlada manualmente clicando no botão Ligar ou Desligar. Este modo também suporta a função Max Idle Time. Insira um tempo máximo (em minutos) a ligação à Internet pode estar inativa antes de ser encerrada no campo Tempo de inatividade máximo. Por defeito o valor é de 15 minutos. Se pretender que a ligação à Internet permaneça sempre ativa, digite 0 (zero)."
                        }
                    ]
                }
            ]
        },
        HELP_PLC_STATION: {
            TITLE: "Lista de dispositivos Powerline",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Apresenta as informações de todos os dispositivos da sua rede Powerline no mesmo circuito elétrico."
                }, {
                    type: "name",
                    title: "Dispositivo Local",
                    content: "A que Powerline está ligado atualmente."
                }, {
                    type: "step",
                    content: ["Na lista de dispositivos Powerline, o endereço MAC e a taxa de transmissão de dados do dispositivo correspondente são exibidos da esquerda para a direita.", "Clique no ícone <b>Lixo</b> para remover o dispositivo Powerline correspondente da sua rede.", "Clique no ícone <b>Mais</b> para adicionar um novo dispositivo Powerline usando as credenciais do dispositivo na da sua rede Powerline."]
                }, {
                    type: "name",
                    title: "Recuar",
                    content: "Clique para voltar à página de Estado."
                }, {
                    type: "name",
                    title: "Atualizar",
                    content: "Clique para atualizar a página."
                }
            ]
        },
        INTERNET_MAC: {
            TITLE: "Clonar MAC",
            CONTENT: [
                {
                    type: "name",
                    title: "Usar endereço MAC padrão",
                    content: "Não altera o endereço MAC predefinido do router, caso o ISP não assigne o endereço IP vinculado a endereço MAC especifico."
                }, {
                    type: "name",
                    title: "Usar endereço MAC do computador atual",
                    content: "Selecione para copiar o endereço MAC do computador que é ligado ao router, caso o ISP vincule o endereço IP atribuído ao endereço MAC deste computador."
                }, {
                    type: "name",
                    title: "Usar endereço MAC personalizado",
                    content: "Digite o endereço MAC manualmente, caso o ISP vincule o endereço IP atribuído a um endereço MAC específico."
                }
            ]
        },
        LAN_IPV4: {
            TITLE: "Definições LAN",
            CONTENT: [
                {
                    type: "name",
                    title: "Tipo LAN",
                    content: "Selecione IP Dinâmico ou IP Fixo."
                }, {
                    type: "name",
                    title: "IP Dinâmico",
                    content: "Selecione esta opção para obter um IP automaticamente do serviço de DHCP."
                }, {
                    type: "name",
                    title: "IP Estático",
                    content: "Selecione esta opção para definir o endereço IP, mascara de Rede e Gateway padrão manualmente."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Apresenta o endereço IP padrão do extensor, que é usado para efetuar o login na página de gestão do extensor, o mesmo pode ser substituído."
                }, {
                    type: "name",
                    title: "Máscara de Rede",
                    content: "Selecione um identificador atribuído usado pela porta LAN para encaminhar tráfego interno e externo a partir da lista ou introduza uma nova máscara de sub-rede em formato decimal separado por pontos."
                }, {
                    type: "name",
                    title: "Gateway padrão",
                    content: "Endereço IP usado para conectar o extensor à sua rede."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Guardar</b> para guardar as suas definições."
                }
            ]
        },
        LED_TIME: {
            TITLE: "Programação LED",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "As Programações de LED permitem Ligar (ou Desligar) os LEDs do Powerline de acordo com um horário à especifico."
                }, {
                    type: "name",
                    title: "Programação LED",
                    content: "Mude para <b>Ligado</b> para ativar a função Programação LED."
                }
            ]
        },
        LED_TIME_GRID: {
            TITLE: "Programação Desligar LED",
            CONTENT: [
                {
                    type: "name",
                    title: "Inicio",
                    content: "Apresenta a hora em que o LED está desligado."
                }, {
                    type: "name",
                    title: "Fim",
                    content: "Apresenta a hora em que o LED está novamente ligado."
                }, {
                    type: "name",
                    title: "Dia(s)",
                    content: "Apresenta o(s) dia(s) efetivo(s) da programação."
                }, {
                    type: "name",
                    title: "ESTADO",
                    content: "Indica o estado atual da programação correspondente. Clique no ícone <b>Lâmpada</b> para ativar (ou desativar) a programação."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Apresenta opções para <b>Modificar</b> ou <b>Remover</b> a programação correspondente."
                }, {
                    type: "step",
                    title: "Para criar nova parametrização",
                    content: ["1. Clique em <b>Adicionar</b>.", "2. Especifique um intervalo de tempo durante o qual o LED será desligado.", "3. Selecione o(s) dia(s) da semana quando esta programação será efetiva.", "4. Selecione <b>Ativar esta entrada</b>.", "5. Clique em <b>OK</b> para guardar as suas definições."]
                }, {
                    type: "paragraph",
                    content: "Para modificar ou remover uma programação, basta clicar no ícone <b>Editar</b> para editar as informações ou no ícone <b>Lixo</b> para remover a programação correspondente."
                }, {
                    type: "paragraph",
                    content: "Para remover vários agendamentos, selecione os agendamentos que pretender remover e clique em <b>Remover</b> no topo da tabela."
                }
            ]
        },
        HELP_PLC: {
            TITLE: "Powerline",
            CONTENT: [
                {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Endereço especifico atribuído ao dispositivo Powerline."
                }, {
                    type: "name",
                    title: "Senha Powerline",
                    content: "Chave exclusiva deste dispositivo Powerline que é usada quando está adicionar à sua rede Powerline existente. A senha encontra-se impressa na etiqueta do produto."
                }, {
                    type: "name",
                    title: "Nome Rede",
                    content: "Apresenta o nome da sua rede Powerline do qual o dispositivo Powerline pertence. Pode renomear a rede aqui ou clique em Padrão para repor os valores de fábrica, por exemplo HomePlugAV. Observe que, se o nome padrão de fábrica estiver já em uso, função Wi-Fi Move será automaticamente desativada."
                }
            ]
        },
        IPTV: {
            TITLE: "Definições",
            CONTENT: [
                {
                    type: "name",
                    title: "IPTV",
                    content: "Selecione para ativar a função de IPTV."
                }, {
                    type: "name",
                    title: "Modo",
                    content: "Selecione o modo adequado de acordo com o seu ISP. Existem seis modos de IPTV suportados:",
                    children: [
                        {
                            type: "name",
                            title: "Ponte (Bridge)",
                            content: "Se o seu ISP não constar na listagem e se não forem necessárias outras definições, basta selecionar este modo e configurar os recursos da porta LAN do seu router.",
                            children: [
                                {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "Atribua a sua porta LAN para funcionar como fornecedor da Internet ou como fornecedor de IPTV."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Rússia",
                            content: "Selecione se o seu ISP é da Rússia e os parâmetros necessários são pré-determinados, incluindo Prioridade e ID de VLAN de Internet / Telefone IP/IPTV as e funções das portas LAN (1/2/3/4).",
                            children: [
                                {
                                    type: "name",
                                    title: "IPTV Multicast Vlan ID/Prioridade",
                                    content: "Pode ativar a função de IPTV multicast como desejado e configurar o ID VLAN e Prioridade de acordo com o seu ISP."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Singapore-ExStream",
                            content: "Selecione se o seu ISP é a Exstream de Singapura e os parâmetros necessários são pré-determinados, incluindo Prioridade e ID de VLAN de Internet / Telefone IP/IPTV as e funções das portas LAN (1/2/3/4)."
                        }, {
                            type: "name",
                            title: "Malaysia-Unifi",
                            content: "Selecione se o seu ISP é a Unifi da Malásia e os parâmetros necessários são pré-determinados, incluindo Prioridade e ID de VLAN de Internet / Telefone IP/IPTV as e funções das portas LAN (1/2/3/4)."
                        }, {
                            type: "name",
                            title: "Malaysia-Maxis",
                            content: "Selecione se o seu ISP é a Maxis da Malásia e os parâmetros necessários são pré-determinados, incluindo Prioridade e ID de VLAN de Internet / Telefone IP/IPTV as e funções das portas LAN (1/2/3/4) ."
                        }, {
                            type: "name",
                            title: "Personalizar",
                            content: "Selecione se o seu ISP não estiver na lista, mas fornece os parâmetros necessários, incluindo Prioridade e ID de VLAN de Internet / Telefone IP/IPTV as e funções das portas LAN (1/2/3/4).",
                            children: [
                                {
                                    type: "name",
                                    title: "Internet/IP-Phone/ID Vlan IPTV/Prioridade",
                                    content: "Configure as ID's das VLAN's fornecidas pelo seu ISP."
                                }, {
                                    type: "name",
                                    title: "802.11Q Tag",
                                    content: "Selecione para marcar os pacotes de Internet com 802.11Q."
                                }, {
                                    type: "name",
                                    title: "IPTV Multicast Vlan ID/Prioridade",
                                    content: "Pode ativar a função de IPTV multicast como desejado e configurar o ID VLAN e Prioridade de acordo com o seu ISP."
                                }, {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "Configurar a porta LAN para acesso à Internet ou como fornecedor IPTV."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "IGMP Proxy",
                    content: "Selecione a versão de Proxy IGMP (Internet Group Management Protocol) , V2 ou V3, de acordo com o seu ISP."
                }
            ]
        },
        DHCP_SERVER_SETTINGS: {
            TITLE: "Definições",
            CONTENT: [
                {
                    type: "name",
                    title: "Servidor DHCP",
                    content: "Por defeito, o servidor de DHCP (Dynamic Host Configuration Protocol) está ativo; O mesmo atribui parâmetros de TCP / IP dinamicamente para os seus dispositivos. NÃO desabilite o servidor DHCP exceto disponha de um outro servidor DHCP ou caso deseje atribuir manualmente os parâmetros TCP / IP a cada dispositivo na sua rede."
                }, {
                    type: "name",
                    title: "Tabela endereços IP",
                    content: "Inserir o intervalo de endereços IP que podem ser atribuídos a clientes."
                }, {
                    type: "name",
                    title: "Address Lease Time",
                    content: "Inserir a duração da atribuição de um endereço IP a um cliente entre, 2 a 2880 minutos. O valor predefinido é 120 minutos)"
                }, {
                    type: "name",
                    title: "Gateway padrão",
                    content: "Digite o endereço IP LAN. (Opcional)"
                }, {
                    type: "name",
                    title: "DNS Primário/DNS Secundário",
                    content: "Entre esses parâmetros fornecidos pelo seu provedor. (Opcional)"
                }
            ]
        },
        RESERVED_IP_ADDRESS: {
            TITLE: "Reserva de Endereços",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Pode reservar um endereço IP manualmente para um cliente que está conectado ao router Uma vez reservado, o endereço IP será atribuído sempre ao mesmo cliente pelo servidor DHCP."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Mostra o endereço MAC do cliente com endereço IP reservado no servidor DHCP ."
                }, {
                    type: "name",
                    title: "Reserva de endereços IP",
                    content: "Mostra o endereço IP reservado do cliente."
                }, {
                    type: "name",
                    title: "Descrição",
                    content: "Mostra uma descrição do dispositivo cliente."
                }, {
                    type: "name",
                    title: "ESTADO",
                    content: "Mostra o status atual (ativado ou desativado) do dispositivo cliente."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Mostra opções para Modificar ou Apagar o cliente correspondente."
                }, {
                    type: "step",
                    title: "Para reservar endereço IP",
                    content: [
                        "1. Clique em Adicionar.",
                        "2. Digite o endereço MAC do dispositivo desejado.",
                        "3. Digite o endereço IP que deseja reservar para o dispositivo.",
                        "4. Digite uma descrição para o dispositivo.",
                        "5. Selecione Ativar.",
                        "6. Clique em OK."
                    ]
                }, {
                    type: "step",
                    title: "Para modificar ou remover um cliente existente",
                    content: "Na tabela, clique no ícone Editar ou no ícone Remover que corresponde ao cliente que deseja modificar ou remover."
                }
            ]
        },
        DHCP_CLIENT_LIST: {
            TITLE: "Lista de Clientes DHCP",
            CONTENT: [
                {
                    type: "name",
                    title: "Numero de Clientes",
                    content: "Apresenta o número de clientes DHCP associados."
                }, {
                    type: "name",
                    title: "Nome de Cliente",
                    content: "Mostra o nome do cliente DHCP."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Mostra o endereço MAC."
                }, {
                    type: "name",
                    title: "Atribuir endereço IP",
                    content: "Exibe o endereço IP atribuído ao cliente pelo servidor DHCP."
                }, {
                    type: "name",
                    title: "Lease Time",
                    content: "Apresenta a duração do endereço IP que foi atribuído ao dispositivo."
                }, {
                    type: "name",
                    title: "Atualizar",
                    content: "Clique para atualizar a lista de clientes DHCP."
                }
            ]
        },
        DDNS: {
            TITLE: "DNS Dinâmico",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O DNS dinâmico permite que atribua o dispositivo e o nome de domínio a um endereço IP dinâmico da Internet. É útil quando está hospedar o seu próprio site, servidor de FTP ou um outro tipo de servidor ligado ao seu router. Primeiro, é necessário registar-se num provedor de serviços DDNS, por exemplo www.dyndns.com."
                }, {
                    type: "step",
                    title: "Para configurar endereço dinâmico de DNS",
                    content: ["1. Escolha o fornecedor de serviços DDNS.", "2. Digite o nome de utilizador e senha de conta DDNS.", "3. Insira o Nome de Domínio que recebeu do fornecedor do serviço DDNS.", "4. Selecione o intervalo de atualização a partir da lista.", "5. Clique em Entrar e Grave"]
                }, {
                    type: "paragraph",
                    content: "Para alternar entre contas, deve primeiro Sair da conta atual e depois Entre na outra conta com o novo nome de utilizador e senha."
                }
            ]
        },
        ADVANCED_ROUTING_STATIC_ROUTING: {
            TITLE: "Rotas Estáticas",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O routing estático é usado para pré-determinar uma rota fixa para que pacotes de informação de rede chegarem a um dispositivo ou rede específica."
                }, {
                    type: "step",
                    title: "Para definir um Rota Estática",
                    content: [
                        "1. Clique em Adicionar.",
                        "2. Rede de Destino - Introduza um endereço IP em hexadecimal para atribuir a rota estática para esta entrada.",
                        "3. Máscara de rede - Insira uma máscara de rede no formato hexadecimal para determinar a parte da rede e a parte do anfitrião de um endereço IP.",
                        "4. Gateway Padrão - Introduza um endereço IP de gateway no formato hexadecimal para ligar o router à rede ou anfitrião.",
                        "5. Interface - Selecione LAN ou WAN para especificar o tipo de Rede de Destino.",
                        "6. Descrição - Insira uma breve descrição para esta entrada.",
                        "7. Selecionar Ativar.",
                        "8. Clique em OK."
                    ]
                }, {
                    type: "step",
                    title: "Para modificar ou remover uma entrada existente",
                    content: "Na tabela, clique no ícone Editar ou no ícone Remover correspondente à entrada que deseja modificar ou remover."
                }
            ]
        },
        ADVANCED_ROUTING_SYSTEM_ROUTING: {
            TITLE: "Tabela de Routing de Sistema",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A tabela de routing mostra todas as entradas de rotas válidas que estão atualmente em uso."
                }, {
                    type: "paragraph",
                    content: "Clique em Atualizar para atualizar a tabela de routing."
                }
            ]
        },
        WIRELESS_REGION: {
            TITLE: "Definições",
            CONTENT: [
                {
                    type: "name",
                    title: "Região",
                    content: "Selecione a sua região no seguinte menu. Se o seu país ou região não estiver especificado, poderá ficar restringido de utilizar o modulo Wi-Fi na sua região."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Guardar</b> para salvaguardar as suas configurações."
                }
            ]
        },
        WIRELESS_BOTH: {
            TITLE: "Wi-Fi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "As instruções abaixo indicadas são para redes Wi-Fi nas bandas <span class=\"anti_5g\"> 2.4GHz e 5GHz </span>."
                }, {
                    type: "name",
                    title: "Ativar Radio Wireless",
                    content: "Selecione esta opção para ativar a frequência de rádio sem fios."
                }, {
                    type: "name",
                    title: "Nome da Rede (SSID)",
                    content: "Pode manter o nome de rede Wireless (SSID) padrão, ou criar um novo nome (até 32 caracteres). Este campo diferencia-se de letras maiúsculas e minúsculas."
                }, {
                    type: "name",
                    title: "Esconder SSID",
                    content: "Marque esta opção se pretende ocultar o nome da sua rede Wireless (SSID) da listagem de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Senha",
                    content: "Crie uma senha para sua rede wireless entre 8 e 63 caracteres ASCII ou entre 8 e 64 caracteres hexadecimais para proteger a sua rede Wi-Fi."
                }, {
                    type: "name",
                    title: "Avançado",
                    content: "Clique aqui para exibir as configurações avançadas."
                }, {
                    type: "name",
                    title: "Segurança",
                    content: "Escolha uma das seguintes opções de segurança:",
                    children: [
                        {
                            type: "name",
                            title: "Sem Segurança",
                            content: "Selecione esta opção para desativar a segurança da sua rede wireless. É <b>altamente recomendado</b> que ative a segurança da sua rede wireless, para proteger de acessos não autorizados."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "Selecione esta opção para ativar o método de autenticação standard, com base numa chave pré-partilhada (PSK). Esta é a opção mais comum e recomendada. Se selecionado, configure os passos seguintes.",
                            children: [
                                {
                                    type: "name",
                                    title: "Versão",
                                    content: "Selecione uma versão de segurança para a sua rede sem fio.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "Esta opção oferece suporte a múltiplas implementações standard do WPA (Wi-Fi Protected Access) , como o WPA e WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Esta opção suporta encriptação em TKIP e AES."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Esta opção fornece um nível de segurança superior do que o modo WPA-PSK e é a mais recomendada."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Encriptação",
                                    content: "Selecione um tipo de encriptação de segurança: <b>TKIP</b> (Temporal Key Integrity Protocol), <b>AES</b> (Advanced Encryption Standard) ou em <b>Auto</b>). <b>NÃO</b> é recomendado usar a encriptação TKIP se o Powerline funcionar na norma Wi-Fi 802.11n, porque o TKIP não é suportado pela especificação da mesma."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Selecione esta opção para ativar o método de autenticação básica se algum dos seus dispositivos só permitir ligações à sua rede wireless usando o protocolo WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Tipo",
                                    content: "Selecione um tipo de autenticação para sua rede Wi-Fi. O padrão é <b>Auto</b>, que escolhe automaticamente <b>Sistema Aberto</b> ou <b>Chave partilhada</b> com base no tipo de dispositivo."
                                }, {
                                    type: "name",
                                    title: "Chave Selecionada",
                                    content: "Selecione uma das quatro chaves."
                                }, {
                                    type: "name",
                                    title: "Formato de Chave WEP",
                                    content: "Utilize o formato <b>ASCII</b> ou <b>Hexadecimal</b>. O formato ASCII é uma combinação de caracteres alfanuméricos.  Formato hexadecimal é uma combinação de números (0-9) e letras (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Tipo de Chave",
                                    content: "Selecione o tamanho da chave WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "Permite-lhe introduzir 10 dígitos hexadecimais (0-9, A-F, a-f) ou 5 caracteres ASCII no campo da palavra-passe."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "Permite-lhe introduzir 26 dígitos hexadecimais (0-9, A-F, a-f) ou 13 caracteres ASCII no campo da palavra-passe."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modo",
                    content: "Selecione um modo de transmissão misto."
                }, {
                    type: "name",
                    title: "Largura de Canal",
                    content: "Selecione o canal de rádio Wi-Fi e a largura de banda para a rede Wi-Fi correspondente."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Selecione um canal rádio para a sua rede Wi-Fi correspondente. É recomendável deixar o canal em <b>Auto</b>, no caso de não verificar constrangimentos no acesso à sua rede Wi-Fi."
                }, {
                    type: "name",
                    title: "Potencia Transmissão",
                    content: "Selecione <b>Alto</b>, <b>Médio</b> ou <b>Baixo</b> para especificar a potência de transmissão de dados. A configuração padrão recomendada é em <b>Alta</b>."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Guardar</b> para salvaguardar as suas configurações."
                }
            ]
        },
        WIRELESS_24G: {
            TITLE: "Wi-Fi 2.4GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Ativar Radio Wireless",
                    content: "Selecione esta opção para ativar o rádio Wi-Fi com a frequência 2.4GHz."
                }, {
                    type: "name",
                    title: "Nome da Rede (SSID)",
                    content: "Pode deixar o nome da rede Wi-Fi (SSID) predefinido ou introduzir um novo nome (até 32 caracteres). Este campo é sensível a caracteres em maiúsculas e minúsculas."
                }, {
                    type: "name",
                    title: "Esconder SSID",
                    content: "Selecione esta opção para ocultar o nome da rede 2.4GHz (SSID) da lista de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Senha",
                    content: "Crie uma senha para rede Wi-Fi entre 8 e 63 caracteres ASCII ou entre 8 e 64 caracteres hexadecimais para proteger a sua rede Wi-Fi."
                }, {
                    type: "name",
                    title: "Avançado",
                    content: "Clique para exibir as configurações avançadas."
                }, {
                    type: "name",
                    title: "Segurança",
                    content: "Escolha uma das seguintes opções de segurança:",
                    children: [
                        {
                            type: "name",
                            title: "Sem Segurança",
                            content: "Selecione esta opção para desativar a segurança da sua rede Wi-Fi. É <b>altamente recomendado</b> que ative a segurança da rede Wi-Fi para proteger a mesma de acessos não autorizados."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "Selecione esta opção para ativar o método de autenticação standard, com base numa chave pré-partilhada (PSK). Esta é a opção mais comum e recomendada. Se selecionado, configure os seguintes passos.",
                            children: [
                                {
                                    type: "name",
                                    title: "Versão",
                                    content: "Selecione uma versão de segurança para a sua rede sem fio.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "Esta opção oferece suporte a múltiplas implementações standard do WPA (Wi-Fi Protected Access) , como o WPA e WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Esta opção suporta encriptação em TKIP e AES."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Esta opção suporta encriptação AES que oferece um melhor nível de segurança do que o modo WPA-PSK e é o recomendado."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Encriptação",
                                    content: "Selecione um tipo de encriptação de segurança: <b>TKIP</b> (Temporal Key Integrity Protocol), <b>AES</b> (Advanced Encryption Standard) ou em <b>Auto</b>). <b>NÃO</b> é recomendado usar a encriptação TKIP se o Powerline funcionar na norma Wi-Fi 802.11n, porque o TKIP não é suportado pela especificação da mesma."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Selecione esta opção para ativar o método de autenticação básica se algum dos seus dispositivos só permitir ligações à sua rede wireless usando o protocolo WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Tipo",
                                    content: "Selecione um tipo de autenticação para sua rede Wi-Fi. O padrão é <b>Auto</b>, que escolhe automaticamente <b>Sistema Aberto</b> ou <b>Chave partilhada</b> com base no tipo de dispositivo."
                                }, {
                                    type: "name",
                                    title: "Chave Selecionada",
                                    content: "Selecione uma das quatro chaves."
                                }, {
                                    type: "name",
                                    title: "Formato de Chave WEP",
                                    content: "Use o formato ASCII ou Hexadecimal. O formato ASCII é uma combinação de caracteres alfanuméricos. Formato hexadecimal é uma combinação de números (0-9) e letras (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Tipo de Chave",
                                    content: "Selecione o tamanho da chave WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "Permite-lhe introduzir 10 dígitos hexadecimais (0-9, A-F, a-f) ou 5 caracteres ASCII no campo da palavra-passe."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "Permite-lhe introduzir 26 dígitos hexadecimais (0-9, A-F, a-f) ou 13 caracteres ASCII no campo da palavra-passe."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modo",
                    content: "Selecione um modo de transmissão misto."
                }, {
                    type: "name",
                    title: "Largura de Canal",
                    content: "Selecione a largura de canal (largura de banda) para a rede Wi-Fi 2.4GHz."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Selecione um canal rádio na banda Wi-Fi 2.4GHz para a sua rede wireless. É recomendável deixar o canal em <b>Auto</b>, no caso de não verificar constrangimentos no acesso à sua rede Wi-Fi."
                }, {
                    type: "name",
                    title: "Potência Transmissão",
                    content: "Selecione <b>Alto</b>, <b>Médio</b> ou <b>Baixo</b> para especificar a potência de transmissão de dados. A configuração padrão recomendada é em <b>Alta</b>."
                }
            ]
        },
        WIRELESS_5G: {
            TITLE: "Wi-Fi 5GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Ativar Radio Wireless",
                    content: "Selecione esta opção para ativar o rádio Wi-Fi com a frequência 5GHz."
                }, {
                    type: "name",
                    title: "Nome da Rede (SSID)",
                    content: "Pode manter o nome de rede Wireless (SSID) padrão, ou criar um novo nome (até 32 caracteres). Este campo diferencia-se de letras maiúsculas e minúsculas."
                }, {
                    type: "name",
                    title: "Esconder SSID",
                    content: "Selecione esta opção para ocultar o nome da rede 5GHz (SSID) da lista de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Senha",
                    content: "Crie uma senha para sua rede wireless entre 8 e 63 caracteres ASCII ou entre 8 e 64 caracteres hexadecimais para proteger a sua rede Wi-Fi."
                }, {
                    type: "name",
                    title: "Avançado",
                    content: "Clique aqui para exibir as configurações avançadas."
                }, {
                    type: "name",
                    title: "Segurança",
                    content: "Escolha uma das seguintes opções de segurança:",
                    children: [
                        {
                            type: "name",
                            title: "Sem Segurança",
                            content: "Selecione esta opção para desativar a segurança da sua rede wireless. É <b>altamente recomendado</b> que ative a segurança da sua rede wireless, para proteger de acessos não autorizados."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "Selecione esta opção para ativar o método de autenticação standard, com base numa chave pré-partilhada (PSK). Esta é a opção mais comum e recomendada. Se selecionado, configure os passos seguintes.",
                            children: [
                                {
                                    type: "name",
                                    title: "Versão",
                                    content: "Selecione uma versão de segurança para a sua rede sem fio.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "Esta opção oferece suporte a múltiplas implementações standard do WPA (Wi-Fi Protected Access) , como o WPA e WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Esta opção suporta encriptação em TKIP e AES."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Esta opção suporta encriptação AES que oferece um melhor nível de segurança do que o modo WPA-PSK e é o recomendado."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Encriptação",
                                    content: "Selecione um tipo de encriptação de segurança: <b>TKIP</b> (Temporal Key Integrity Protocol), <b>AES</b> (Advanced Encryption Standard) ou em <b>Auto</b>). <b>NÃO</b> é recomendado usar a encriptação TKIP se o Powerline funcionar na norma Wi-Fi 802.11n, porque o TKIP não é suportado pela especificação da mesma."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Selecione esta opção para ativar o método de autenticação básica se algum dos seus dispositivos só permitir ligações à sua rede wireless usando o protocolo WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Tipo",
                                    content: "Selecione um tipo de autenticação para sua rede Wi-Fi. O padrão é <b>Auto</b>, que escolhe automaticamente <b>Sistema Aberto</b> ou <b>Chave partilhada</b> com base no tipo de dispositivo."
                                }, {
                                    type: "name",
                                    title: "Chave Selecionada",
                                    content: "Selecione uma das quatro chaves."
                                }, {
                                    type: "name",
                                    title: "Formato de Chave WEP",
                                    content: "Utilize o formato <b>ASCII</b> ou <b>Hexadecimal</b>. O formato ASCII é uma combinação de caracteres alfanuméricos.  Formato hexadecimal é uma combinação de números (0-9) e letras (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Tipo de Chave",
                                    content: "Selecione o tamanho da chave WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "Permite-lhe introduzir 10 dígitos hexadecimais (0-9, A-F, a-f) ou 5 caracteres ASCII no campo da palavra-passe."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "Permite-lhe introduzir 26 dígitos hexadecimais (0-9, A-F, a-f) ou 13 caracteres ASCII no campo da palavra-passe."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modo",
                    content: "Selecione um modo de transmissão misto."
                }, {
                    type: "name",
                    title: "Largura de Canal",
                    content: "Selecione a largura de canal (largura de banda) para a rede Wi-Fi 5GHz."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Selecione um canal de funcionamento para a rede Wi-Fi 5GHz. Auto é a opção predefinida e recomendada. Recomendamos deixar o canal em Auto se não tiver problemas intermitentes de ligação Wi-Fi."
                }, {
                    type: "name",
                    title: "Potência Transmissão",
                    content: "Selecione Alto, Médio ou Baixo para especificar a potência de transmissão de dados. A configuração padrão recomendada é em Alta."
                }, {
                    type: "paragraph",
                    content: "Clique em Gravar para guardar todas as suas configurações."
                }
            ]
        },
        WIFI_TIME_CONTROL: {
            TITLE: "Programação Wi-Fi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A Programação Wi-Fi permite definir horários específicos para desativar o Wi-Fi."
                }, {
                    type: "name",
                    title: "Programação Wi-Fi",
                    content: "Mude para <b>Ligado</b> para ativar a função Programação Wi-Fi. Se pretender que o Wi-Fi permaneça ativo enquanto os dispositivos wireless ainda permanecerem ligados à sua rede Wi-Fi, selecione a caixa de verificação."
                }
            ]
        },
        WIFI_CLONE: {
            TITLE: "Wi-Fi Clone",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Wi-Fi Clone é utilizado para copiar as configurações da sua rede Wi-Fi (incluindo o SSID e a senha) do seu router para o extensor."
                }, {
                    type: "name",
                    title: "Seleção Banda Wi-Fi",
                    content: "Selecione uma <span class=\"anti_5g\">ou ambas</span> para serem clonadas.<span class=\"anti_5g\">Se o seu router apenas suporta o clone de bandas individualmente, recomendamos que selecione aqui ambas as bandas 2.4GHz e 5GHz, para garantir que a clonagem é efetuada com sucesso.</span>"
                }
            ]
        },
        WIFI_TIME_GRID: {
            TITLE: "Programação Desligar Wi-Fi",
            CONTENT: [
                {
                    type: "name",
                    title: "Inicio",
                    content: "Apresenta a hora em que o Wi-Fi está Desativado."
                }, {
                    type: "name",
                    title: "Fim",
                    content: "Apresenta a hora em que o Wi-Fi está novamente ligado."
                }, {
                    type: "name",
                    title: "Dia(s)",
                    content: "Apresenta o(s) dia(s) efetivo(s) da programação."
                }, {
                    type: "name",
                    title: "ESTADO",
                    content: "Indica se a agenda está ativada ou não. Clique no ícone da Lâmpada para ativar (ou desativar) a programação."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Apresenta as opções para <b>Modificar</b> ou <b>Remover</b> a entrada correspondente."
                }, {
                    type: "step",
                    title: "Para adicionar uma nova programação",
                    content: ["1. Clique em <b>Adicionar</b>.", "2. Indique o intervalo de tempo durante o qual o Wi-Fi será desligado.", "3. Selecione o(s) dia(s).", "4. Selecione <b>Ativar esta entrada</b>.", "5. Clique em <b>OK</b> para guardar esta entrada."]
                }, {
                    type: "paragraph",
                    content: "Para modificar ou remover uma entrada para desativar o Wi-Fi, basta clicar no ícone <b>Editar</b> para editar as informações ou no ícone <b>Lixo</ b> para remover a entrada correspondente."
                }, {
                    type: "paragraph",
                    content: "Para remover vários agendamentos, selecione todos os agendamentos e clique em <b>Remover</ b> no topo da tabela."
                }
            ]
        },
        WPS: {
            TITLE: "PIN do Router",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Outros dispositivos podem ligar-se ao router via WPS utilizando o PIN do router."
                }, {
                    type: "name",
                    title: "Ativar PIN Router",
                    content: "Permitir que dispositivos Wi-Fi se conectem ao router usando o PIN (número de identificação pessoal)."
                }, {
                    type: "name",
                    title: "PIN Router",
                    content: "Indica o PIN do router. O PIN por defeito pode ser encontrado na etiqueta do router ou no Guia de Utilizador. Clique em Gerar para criar aleatoriamente um novo PIN ou em Padrão para restaurar o PIN atual para o original."
                }
            ]
        },
        WPS_WIZARD: {
            TITLE: "Guia de Configuração Rápida do WPS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Selecione o método de configuração"
                }, {
                    type: "name",
                    title: "Prima botão (Recomendado)",
                    content: "Selecione este método de configuração para ativar a função WPS no router, que permite que qualquer dispositivo com WPS se possa conectar facilmente à sua rede Wi-Fi usando o botão WPS ou virtualmente usando o botão Conectar."
                }, {
                    type: "name",
                    title: "PIN",
                    content: "Selecione este método de configuração para adicionar um dispositivo manualmente, digitando o PIN WPS do dispositivo Wi-Fi no campo e clicando em Conectar."
                }
            ]
        },
        WIRELESS_STATISTICS: {
            TITLE: "Clientes Wi-Fi Online",
            CONTENT: [
                {
                    type: "name",
                    title: "Total de Clientes",
                    content: "Apresenta o número total de dispositivos Wi-Fi ligados à rede Powerline."
                }, {
                    type: "name",
                    title: "Nome de Dispositivo",
                    content: "Apresenta o nome do dispositivo Wi-Fi."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Apresenta o endereço IP atribuído ao dispositivo Wi-Fi."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Apresenta o endereço MAC do dispositivo Wi-Fi."
                }, {
                    type: "name",
                    title: "Banda Wireless",
                    content: "Apresenta a banda de frequência <span class=\"anti_5g\">(2.4GHz ou 5GHz) </span>da rede Wi-Fi no qual o dispositivo Wi-Fi está ligado."
                }, {
                    type: "name",
                    title: "Segurança",
                    content: "Apresenta o tipo de segurança do dispositivo Wi-Fi."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Atualizar</b> para atualizar as informações desta página."
                }
            ]
        },
        GUEST_NETWORK_BASIC: {
            TITLE: "Rede de Convidados",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "<b>Rede de convidados</b> permite criar uma rede wireless com um nome (SSID) e senha diferente dada sua rede Wi-Fi principal, para acesso à Internet."
                }
            ]
        },
        GUEST_NETWORK_SETTINGS: {
            TITLE: "Rede de Convidados",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "<b>Rede de convidados</b> permite criar uma rede wireless com um nome (SSID) e senha diferente dada sua rede Wi-Fi principal, para acesso à Internet."
                }, {
                    type: "name",
                    title: "Permita que os convidados se vejam",
                    content: "Selecione esta opção para permitir que os dispositivos Wi-Fi comuniquem entre si na rede de convidados."
                }, {
                    type: "name",
                    title: "Não permita que os convidados alterem a sua rede",
                    content: "Selecione esta opção para impedir que os convidados efetuem o login na interface de gestão."
                }, {
                    type: "name",
                    title: "Desativação automática",
                    content: "Selecione esta opção para desligar automaticamente a Rede Convidados com base no horário programado."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Guardar</ b> para salvaguardar todas as suas configurações."
                }
            ]
        },
        GUEST_NETWORK_WIRELESS: {
            TITLE: "Definições da Rede de Convidados",
            CONTENT: [
                {
                    type: "name",
                    title: "2.4GHz | 5GHz",
                    content: "Alterne entre 2,4 GHz e 5 GHz para exibir as suas configurações."
                }, {
                    type: "name",
                    title: "Ativar Rede Convidados",
                    content: "Selecione aqui para ativar a Rede Convidados."
                }, {
                    type: "name",
                    title: "Nome da Rede (SSID)",
                    content: "Utilize o SSID predefinido ou crie um novo nome  de rede Wi-Fi (até 32 caracteres)."
                }, {
                    type: "name",
                    title: "Segurança",
                    content: "Escolha uma das seguintes opções de segurança:",
                    children: [
                        {
                            type: "name",
                            title: "Sem Segurança",
                            content: "Selecione esta opção para desativar a segurança da rede Wi-Fi. <u><b>Recomendamos</u></b> que ative a segurança da rede Wi-Fi para proteger a sua Rede Convidados de acessos não autorizados."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 - Pessoal",
                            content: "Selecione esta opção para ativar o método de autenticação predefinido com base numa chave pré-partilhada (PSK). Esta é a opção mais comum e recomendada. Se selecionado, configure os passos seguintes."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Senha",
                    content: "Utilize a palavra passe predefinida ou crie uma nova palavra passe entre 8 e 63 caracteres ASCII ou entre 8 e 64 caracteres hexadecimais (0-9, a-f, A-F)."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Guardar</b> para salvaguardar as suas configurações Wi-Fi da Rede Convidados."
                }
            ]
        },
        GUEST_NETWORK_WIRELESS_2G: {
            TITLE: "Definições Wi-Fi",
            CONTENT: [
                {
                    type: "name",
                    title: "Ativar Rede Convidados",
                    content: "Clique em <b>Guardar</b> para salvaguardar as suas configurações Wi-Fi da Rede Convidados."
                }, {
                    type: "name",
                    title: "Nome da Rede (SSID)",
                    content: "Utilize o SSID predefinido ou crie um novo nome  de rede Wi-Fi (até 32 caracteres)."
                }, {
                    type: "name",
                    title: "Segurança",
                    content: "Escolha uma das seguintes opções de segurança:",
                    children: [
                        {
                            type: "name",
                            title: "Sem Segurança",
                            content: "Selecione esta opção para desativar a segurança da rede Wi-Fi. <u><b>Recomendamos</b></u> que ative a segurança da rede Wi-Fi para proteger a sua Rede Convidados de acessos não autorizados."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 - Pessoal",
                            content: "Selecione esta opção para ativar o método de autenticação predefinido com base numa chave pré-partilhada (PSK). Esta é a opção mais comum e recomendada. Se selecionado, configure os passos seguintes."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Senha",
                    content: "Utilize a palavra passe predefinida ou crie uma nova palavra passe entre 8 e 63 caracteres ASCII ou entre 8 e 64 caracteres hexadecimais (0-9, a-f, A-F)."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Guardar</b> para salvaguardar as suas configurações Wi-Fi da Rede Convidados."
                }
            ]
        },
        NAT: {
            TITLE: "Application Layer Gateway(ALG)",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O ALG permite personalizar filtros transversais sobre NAT (Network Address Translation) para facilitar a transposição de endereços e portas de protocolos utilizados por determinado tipo de aplicações como FTP, TFTP, H323, etc. É recomendado ativar o ALG."
                }, {
                    type: "name",
                    title: "Ativar FTP ALG",
                    content: "Se selecionado, permite a clientes e servidores FTP (File Transfer Protocol) a transferência de dados via NAT."
                }, {
                    type: "name",
                    title: "Ativar TFTP ALG",
                    content: "Se selecionado, permite a clientes e servidores TFTP (Trivial File Transfer Protocol) a transferência de dados via NAT."
                }, {
                    type: "name",
                    title: "Ativar H323 ALG",
                    content: "Se selecionado, permite que clientes Microsoft NetMeeting comuniquem via NAT."
                }, {
                    type: "name",
                    title: "Ativar RTSP ALG",
                    content: "Se selecionado, permite aos clientes do media player comunicar com servidores de streaming multimédia via NAT."
                }, {
                    type: "name",
                    title: "Ativar PPTP Passthrough",
                    content: "Se selecionado, permite que sessões Ponto-a-Ponto sejam encapsuladas através de uma rede IP e passem pelo Router."
                }, {
                    type: "name",
                    title: "Ativar L2TP Passthrough",
                    content: "Se selecionado, permite que sessões L2 Ponto-a-Ponto sejam encapsuladas através de uma rede IP e passem pelo Router."
                }, {
                    type: "name",
                    title: "Ativar IPSec Passthrough",
                    content: "Quando selecionado o protocolo IPSec (Internet Portocol Security), permite encapsular os dados entre o seu router e uma rede IP. O IPSec utiliza serviços encriptação de segurança para garantir comunicações privadas e seguras através de redes IP."
                }, {
                    type: "paragraph",
                    content: "Clique em Gravar para guardar todas as suas configurações."
                }
            ]
        },
        VIRTUAL_SERVERS: {
            TITLE: "Servidores Virtuais",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Servidores virtuais são usados para configurar serviços públicos em sua rede local. Um servidor virtual é definido como uma porta externa, e todas as solicitações da Internet para esta porta externa serão redirecionadas para um computador designado, que deve ser configurado com um endereço IP estático ou reservado."
                }, {
                    type: "name",
                    title: "Tipo de Serviço",
                    content: "Exibe o nome do seu servidor virtual."
                }, {
                    type: "name",
                    title: "Porto Externo",
                    content: "Exibe o número da porta ou um intervalo de portas usadas pelo servidor virtual."
                }, {
                    type: "name",
                    title: "IP Interno",
                    content: "Mostra o endereço IP do computador que executa o aplicativo de serviço."
                }, {
                    type: "name",
                    title: "Porto Interno",
                    content: "Mostra o número da porta do computador que executa o aplicativo de serviço."
                }, {
                    type: "name",
                    title: "Protocolo",
                    content: "Mostra o protocolo usado para o aplicativo de serviço: TCP, UDP, ou ALL (todos os protocolos suportados pelo router)."
                }, {
                    type: "name",
                    title: "ESTADO",
                    content: "Mostra o status atual (ativado ou desativado) da regra especifica de filtragem."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Mostra opções para Modificar ou Apagar a regra correspondente."
                }, {
                    type: "step",
                    title: "Para configurar uma regra de Servidor Virtual",
                    content: ["1. Clique em Adicionar.", "2. Clique em Ver Serviços Existentes para selecionar um serviço da lista e para preencher automaticamente com o número de porta adequado os campos de Porta Externa e Porta Interna. Se o serviço não estiver na lista, digite o número da porta externa (por exemplo, 21) ou um intervalo de portas (por exemplo, 21-25). Deixe a porta interna em branco se é o mesmo que o da porta externa ou digite um número de porta específico (por exemplo, 21) se a porta externa é uma única porta. Digite o endereço IP do computador que executa o aplicativo de serviço no formato decimal com pontos no campo IP Interno.", "3. Selecione um protocolo para o aplicativo de serviço: TCP, UDP, ou Tudo a partir da lista Protocolo.", "4. Selecione Ativar.", "5. Clique em OK."]
                }, {
                    type: "step",
                    title: "Para modificar ou remover a regra de Servidor Virtual",
                    content: "Clique no ícone Modificar ou no ícone Lixo correspondente à regra que deseja modificar ou remover."
                }, {
                    type: "step",
                    title: "Para remover várias regras",
                    content: "Selecione todas as entradas que deseja remover, e clique em Remover no topo da tabela."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Se o dispositivo local está a alojar mais de um tipo de serviços, terá de criar uma regra para cada serviço."
                }
            ]
        },
        PORT_TRIGGERING: {
            TITLE: "Port Triggering",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Port Triggering é usado para encaminhar tráfego de uma determinada porta para um servidor específico na rede."
                }, {
                    type: "name",
                    title: "Aplicação",
                    content: "Exibe o nome da aplicação"
                }, {
                    type: "name",
                    title: "Triggering Port",
                    content: "Exibe a porta de saída de tráfego usado para acionar uma regra de filtragem de uma ligação de saída."
                }, {
                    type: "name",
                    title: "Protocolo Trigger",
                    content: "Exibe o protocolo usado para o Triggering Port. TCP, UDP, ou Todos (todos os protocolos suportados pelo Router)."
                }, {
                    type: "name",
                    title: "Porto Externo",
                    content: "Exibe o intervalo de portas ou porta usada pelo sistema remoto. Uma resposta usando uma destas portas será encaminhada para o PC que acionou esta regra. Pode introduzir no máximo 5 grupos de portas (ou seções portas). Cada grupo de portas devem ser separados por \",\" (vírgula), por exemplo, 2000-2038, 2046, 2050-2051, 2085, 3010-3030."
                }, {
                    type: "name",
                    title: "Protocolo Externo",
                    content: "Exibe o protocolo utilizado para a Porta de Entrada: TCP, UDP, ou Todos (todos os protocolos suportados pelo Router)."
                }, {
                    type: "name",
                    title: "ESTADO",
                    content: "Mostra o status atual (ativado ou desativado) da regra especifica de filtragem."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Apresenta as opções para Modificar ou Remover as regras correspondentes."
                }, {
                    type: "step",
                    title: "Para configurar uma regra de Port Triggering",
                    content: [
                        {
                            type: "note",
                            title: "Nota",
                            content: "Nota: Cada regra só pode ser usada por um dispositivo de cada vez."
                        },
                        "1. Clique em Adicionar.", {
                            content: "2. Clique em Ver Aplicações Existentes para selecionar um aplicativo da lista para preencher automaticamente os valores predefinidos nos campos apropriados. Se quiser adicionar um aplicativo não listado, digite manualmente Aplicação, Triggering Port, Triggering Protocol, Porta Externa e Protocolo Externo.",
                            children: [
                                {
                                    type: "note",
                                    title: "Nota",
                                    content: "Regras não podem ter quaisquer intervalos de portass que se sobreponham (por exemplo, se a Regra 1 tem o intervalo de portass 4200-4205, a Regra 2 não pode ter um intervalo de portass de 4203-4206)."
                                }
                            ]
                        },
                        "3. Selecione Ativar.",
                        "4. Clique em OK."
                    ]
                }, {
                    type: "step",
                    title: "Para modificar ou remover a regra de Port Triggering",
                    content: "Na tabela, clique no ícone Modificar ou no ícone Lixo correspondente à regra que deseja modificar ou remover."
                }, {
                    type: "step",
                    title: "Para remover várias regras de Port Triggering",
                    content: "Na tabela, selecione todas as regras que você deseja excluir, clique em Apagar acima da tabela."
                }
            ]
        },
        DMZ: {
            TITLE: "DMZ",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A funcionalidade DMZ (zona desmilitarizada) permite que um dispositivo local seja exposto à Internet para uma finalidade especial, como jogar pela Internet ou videoconferência. Basicamente, a DMZ permite que um único computador na LAN possa abrir todas as suas portas. Este computador tem de ser configurado com um endereço IP estático e ter sua função de cliente DHCP desativado."
                }, {
                    type: "step",
                    title: "Para atribuir um computador ou servidor para ser um servidor DMZ",
                    content: ["1. Clique em Ativar DMZ.", "2. No campo Endereço IP de Dispositivo DMZ, digite o endereço IP do computador local que será configurado como o host DMZ.", "3. Clique em Gravar."]
                }
            ]
        },
        UPNP: {
            TITLE: "UPnP",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Por defeito, o função Universal Plug-and-Play (UPnP) está ativada, para permitir que dispositivos como computadores e appliences de Internet possam descobrir e comunicar uns com os outros automaticamente na rede local."
                }, {
                    type: "paragraph",
                    content: "A Lista de Serviços UPnP exibe as informações de dispositivos UPnP."
                }, {
                    type: "name",
                    title: "Descrição de serviço",
                    content: "Exibe uma breve descrição do dispositivo local que inicia a solicitação UPnP."
                }, {
                    type: "name",
                    title: "Porto Externo",
                    content: "Exibe a porta externa que é aberta pelo dispositivo local."
                }, {
                    type: "name",
                    title: "Protocolo",
                    content: "Exibe o tipo de protocolo de rede que é usado pelo dispositivo local."
                }, {
                    type: "name",
                    title: "Endereço IP Interno",
                    content: "Exibe o endereço IP do dispositivo local."
                }, {
                    type: "name",
                    title: "Porto Interno",
                    content: "Exibe a porta interna que é aberta pelo dispositivo local."
                }, {
                    type: "paragraph",
                    content: "Clique em Atualizar para atualizar a lista de Servidores UPnP."
                }
            ]
        },
        DISK_SETTING: {
            TITLE: "Definições de Dispositivo",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A página de Definições de Dispositivo mostra a informação relativa a qualquer dispositivo de armazenamento USB conectado via porta USB."
                }, {
                    type: "name",
                    title: "Pesquisa",
                    content: "Normalmente, o Router deteta automaticamente qualquer dispositivo recentemente conectado. Se tal não suceder, clique no botão Examinar para procura qualquer novo dispositivo conectado e refrescar a página com informações atualizadas."
                }, {
                    type: "name",
                    title: "Volume",
                    content: "Mostra o nome do volume USB."
                }, {
                    type: "name",
                    title: "Capacidade",
                    content: "Mostra a capacidade de armazenamento total do dispositivo USB."
                }, {
                    type: "name",
                    title: "Espaço Livre",
                    content: "Mostra o espaço de armazenamento atualmente disponível."
                }, {
                    type: "name",
                    title: "Remoção Segura",
                    content: "Clique nesse botão para desmontar de forma segura o dispositivo de armazenamento USB antes de desconectá-lo fisicamente da porta USB do router."
                }, {
                    type: "paragraph",
                    content: "A opção Remova em Segurança, apenas está visível quando existe um dispositivo de armazenamento USB está conectado ao seu router e não será possível desmontar o mesmo enquanto estiver em utilização."
                }, {
                    type: "name",
                    title: "Ativo",
                    content: "Esta opção só aparece quando há um dispositivo de armazenamento USB conectado ao router. Selecione para ativar a partilha do conteúdo do dispositivo USB."
                }, {
                    type: "step",
                    title: "Para configurar um servidor de impressão",
                    content: ["1. Conecte o dispositivo de armazenamento USB à porta USB do router usando um cabo USB.", "2. O dispositivo USB conectado deve ser automaticamente detetado pelo Router e exibidas as informações respetivas na seção Definições de Dispositivo. Se não, clique em Examinar.", "3. Selecione Ativar para ativar a partilha de ficheiros."]
                }
            ]
        },
        FOLDER_SHARE_ACCOUNT: {
            TITLE: "Conta de Partilha",
            CONTENT: [
                {
                    type: "name",
                    title: "CONTA",
                    content: "Pode selecionar o uso de conta predefinida para aceder aos arquivos e pastas partilhadas ou Criar Nova Conta,  seguindo os próximos passos para criar uma nova conta de utilizador."
                }, {
                    type: "name",
                    title: "Utilizador/Senha",
                    content: "Digite uma sequência alfanumérica de até 15 caracteres. O nome de utilizador deve começar com um caractere do alfabeto. Estes campos são sensíveis a caracteres em maiúsculas e minúsculas."
                }, {
                    type: "name",
                    title: "Confirme a Senha",
                    content: "Digite novamente a senha para confirmar que não há erro de digitação. Este campo também é sensível a caracteres em maiúsculas e minúsculas."
                }, {
                    type: "paragraph",
                    content: "Clique em Guardar para salvaguardar a nova conta de utilizador."
                }
            ]
        },
        FOLDER_SHARE_SETTINGS: {
            TITLE: "Definições de Partilha",
            CONTENT: [
                {
                    type: "name",
                    title: "Rede/Nome de servidor multimédia",
                    content: "Mostra o nome usado para aceder ao dispositivo de armazenamento USB conectado."
                }, {
                    type: "name",
                    title: "Ativar",
                    content: "Selecione para ativar o método de acesso."
                }, {
                    type: "name",
                    title: "Método de Acesso",
                    content: "Existem três formas de permitir o acesso ao dispositivo de armazenamento USB. Pode escolher um ou mais métodos de acesso através da seguinte opção.",
                    children: [
                        {
                            type: "name",
                            title: "Vizinhança de Rede",
                            content: "Se ativado, os utilizadores na sua rede local podem aceder ao dispositivo de armazenamento USB, usando o endereço IP atribuído (por exemplo, \\\\192.168.0.1). Este é o método padrão."
                        }, {
                            type: "name",
                            title: "FTP",
                            content: "Se ativado, os clientes FTP na sua rede local podem aceder ao dispositivo de armazenamento USB, usando o endereço IP atribuído, seguido do número da porta do servidor FTP (por exemplo ftp://192.168.0.1:21)."
                        }, {
                            type: "name",
                            title: "FTP (Via Internet)",
                            content: "Se ativado, os utilizadores podem aceder remotamente ao dispositivo de armazenamento USB através a partir da Internet via protocolo FTP. Esta função suporta transferências de ficheiros em download e upload. Para alterar o numero da porta do servidor FTP, indique o valor pretendido e clique em Guardar alterações."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Endereço",
                    content: "Mostra o endereço usado para aceder ao dispositivo de armazenamento USB partilhado."
                }, {
                    type: "name",
                    title: "Porto",
                    content: "Mostra o número da porta do servidor FTP."
                }
            ]
        },
        FOLDER_SHARE_FOLDERS: {
            TITLE: "Partilha de Pastas",
            CONTENT: [
                {
                    type: "name",
                    title: "Partilha Completa",
                    content: "Mude para Ligado para partilhar todas as pastas e ficheiros ou mantenha Desligado para partilhar somente pastas especificas."
                }, {
                    type: "name",
                    title: "Ativar Autenticação",
                    content: "É altamente recomendável ativar a autenticação, para exigir que os utilizadores insiram um nome de utilizador e senha válidos para acederem às pastas partilhadas."
                }, {
                    type: "name",
                    title: "Nome da pasta",
                    content: "Mostra o nome da pasta partilhada."
                }, {
                    type: "name",
                    title: "Caminho da pasta",
                    content: "Mostra o caminho para a pasta partilhada."
                }, {
                    type: "name",
                    title: "Partilha de Media",
                    content: "Indica se a pasta partilhada permite ou não a partilha de conteúdos multimédia."
                }, {
                    type: "name",
                    title: "Nome do volume",
                    content: "Exibe o nome do volume partilhado."
                }, {
                    type: "name",
                    title: "ESTADO",
                    content: "Apresenta o estado da pasta partilhada pelo indicador da lâmpada. Verde (ON) é ativado e Cinzento (OFF) é desativado. Pode ativar ou desativar a partilha ao clicar na lâmpada."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Mostra opções para Modificar ou Apagar a pasta partilhada correspondente."
                }, {
                    type: "name",
                    title: "Procurar",
                    content: "Clique para procurar uma pasta partilhada."
                }, {
                    type: "name",
                    title: "Permitir o acesso à rede de Convidados",
                    content: "Selecione para permitir que clientes da Rede de Convidados possam aceder às pastas partilhadas."
                }, {
                    type: "name",
                    title: "Ativar autenticação",
                    content: "Selecionar para obrigar os utilizadores a terem um nome de utilizador e senha válidos para acederem às pastas partilhadas."
                }, {
                    type: "name",
                    title: "Ativar autorização para gravação",
                    content: "Selecione para permitir que os utilizadores façam alterações no conteúdo da pasta."
                }, {
                    type: "name",
                    title: "Ativar partilha de ficheiros multimédia",
                    content: "Selecione para ativar a partilha de Média."
                }
            ]
        },
        PRINT_SERVER: {
            TITLE: "Servidor de Impressão",
            CONTENT: [
                {
                    type: "step",
                    title: "Para configurar um servidor de impressão que pode ser usado em toda a rede",
                    content: ["1. Conecte uma impressora USB à porta USB do router através do cabo USB.", "2. Instale os controladores da impressora no seu computador. Consulte os manuais do fabricante para obter as instruções.", "3. Instale o Utilitário do Controlador de Impressora USB TP-LINK, a partir do CD de Instalação (apenas para Windows) ou faça o download da versão mais recente (para Windows e Mac OS X) no site oficial da TP-LINK."]
                }
            ]
        },
        PARENTAL_CONTROL: {
            TITLE: "Controlo Parental",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Com o Controlo Parental, pode definir limites de tempo para dispositivos Wi-Fi e controlar quando os mesmos podem aceder à Internet."
                }, {
                    type: "name",
                    title: "Controlo Parental",
                    content: "Mude para <b>Ligado</b> para ativar o Controlo Parental."
                }
            ]
        },
        PARENTAL_CONTROL_DEVICES: {
            TITLE: "Dispositivos sob Controlo Parental",
            CONTENT: [
                {
                    type: "name",
                    title: "ID",
                    content: "Apresenta o ID do dispositivo cliente."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Apresenta o endereço MAC do dispositivo cliente."
                }, {
                    type: "name",
                    title: "Tempo de acesso à Internet",
                    content: "Apresenta os períodos de tempo de acesso permitidos."
                }, {
                    type: "name",
                    title: "Descrição",
                    content: "Mostra uma breve descrição do dispositivo ligado. É uma configuração opcional."
                }, {
                    type: "name",
                    title: "ESTADO",
                    content: "Indica se o Controlo Parental está ou não ativo para o dispositivo correspondente."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Apresenta as opções para <b>Modificar</b> ou <b>Remover</b> do dispositivo."
                }, {
                    type: "step",
                    title: "Para definir limite de tempo para um novo dispositivo",
                    content: [
                        "1. Clique em <b>Adicionar</b>.",
                        "2. Clique em <b>Apresentar os dispositivos existentes</b> e escolha um dispositivo que está atualmente ligado da Lista <b>Dispositivo de acesso Wi-Fi</b>; ou introduza o <b>Endereço MAC</b> para adicionar um dispositivo que não esteja ligado.",
                        "3. Clique no ícone <b>Tempo de acesso à Internet</b> para especificar intervalos de tempo durante os quais o dispositivo tem permissão para aceder à Internet.",
                        "4. Insira uma breve descrição no campo <b>Descrição</b>. Este campo é facultativo.",
                        "5. Selecione <b>Ativar esta entrada</b>.",
                        "6. Clique em <b>OK</b> para guardar esta entrada."
                    ]
                }, {
                    type: "paragraph",
                    content: "Para modificar ou remover um dispositivo da lista, basta clicar no ícone <b>Editar</b> para editar as informações ou no ícone <b>Lixo</b> para remover a entrada correspondente."
                }, {
                    type: "paragraph",
                    content: "Para remover vários dispositivos da lista, marque na caixa de seleção correspondente dos dispositivos a serem removidos e clique em <b>Remover</b> no topo da tabela."
                }
            ]
        },
        PARENTAL_CONTROL_RESTRICTION: {
            TITLE: "Restrição de Conteúdos",
            CONTENT: [
                {
                    type: "name",
                    title: "Lista Negra",
                    content: "Contém as palavras-chave que serão utilizadas para bloquear acesso a qualquer site a partir de dispositivos especificados na lista de Controlo Parental.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Clique em Adicionar Nova Palavra para adicionar uma palavra-chave à lista negra. Para excluir uma palavra-chave, clique no ícone (-) da palavra-chave que deseja eliminar."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Lista Branca",
                    content: "Contém os endereços dos sites aos quais os dispositivos especificados na lista de Controlo Parental têm acesso.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Clique em Adicionar Novo Nome de Domínio para adicionar um site à lista de permissões. Para excluir um site, clique no ícone (-) do site que deseja eliminar."
                        }
                    ]
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Palavras-chave também podem ser nomes de domínio, por exemplo, www.mail.google.com ou www.facebook.com."
                }, {
                    type: "paragraph",
                    content: "Clique em Gravar para guardar todas as suas configurações."
                }
            ]
        },
        QOS: {
            TITLE: "QoS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A Qualidade de Serviço (QoS) ajuda a priorizar o tráfego da Internet baseado nas suas necessidades. Pode personalizar o nível de prioridade de um dispositivo ou uma aplicação na lista de regras de QoS."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Se NAT Boost estiver ativado, o QoS deve ser desativo."
                }, {
                    type: "name",
                    title: "Active QoS",
                    content: "Clique aqui para ativar a função QoS."
                }, {
                    type: "name",
                    title: "Largura de banda Upload",
                    content: "Introduza a largura de banda de Upload máxima fornecida pelo seu ISP (Internet Service Provider)."
                }, {
                    type: "name",
                    title: "Largura de banda Download",
                    content: "Digite a largura de banda de download máxima fornecida pelo seu ISP."
                }, {
                    type: "name",
                    title: "Garantia de alta prioridade",
                    content: "Especifique a percentagem para o tráfego de alta prioridade."
                }, {
                    type: "name",
                    title: "Garantia de prioridade média",
                    content: "Especifique a percentagem para o tráfego de prioridade média."
                }, {
                    type: "name",
                    title: "Garantia de baixa prioridade",
                    content: "Especifique a percentagem para o tráfego de baixa prioridade."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "O valor (em percentagem) de todas as prioridades deve ser 1."
                }, {
                    type: "paragraph",
                    content: "Clique em Gravar para guardar todas as suas configurações."
                }
            ]
        },
        QOS_RULE: {
            TITLE: "Lista de Regras QoS",
            CONTENT: [
                {
                    type: "name",
                    title: "Tipo",
                    content: "Selecione um tipo para adicionar regra de QoS à lista."
                }, {
                    type: "step",
                    title: "Para configurar uma regra para alta/média/baixa prioridade por dispositivos",
                    content: ["1. Clique em Adicionar.", "2. Selecione Por Dispositivo.", "3. Clique em Ver Dispositivos Existentes para selecionar o dispositivo desejado na Lista de Dispositivos de Acesso, ou pode digitar um nome de dispositivo e respetivo endereço MAC manualmente nos campos Nome do Dispositivo e Endereço MAC.", "4. Clique em OK."]
                }, {
                    type: "step",
                    title: "Para configurar uma regra para alta/média/baixa prioridade por Aplicação",
                    content: ["1. Clique em Adicionar.", "2. Selecione Por Aplicação.", "3. Selecione a aplicação desejada da lista de Aplicações ou personalize a aplicação, atribuindo o nome, o protocolo e a porta nos campos correspondentes.", "4. Clique em OK."]
                }, {
                    type: "step",
                    title: "Para configurar uma regra para alta / média / baixa prioridade por Porta Física",
                    content: ["1. Clique em Adicionar.", "2. Selecione Por Porta Física.", "3. Selecione a porta desejada.", "4. Clique em OK."]
                }
            ]
        },
        QOS_DATABASE: {
            TITLE: "Atualização da Base de Dados",
            CONTENT: [
                {
                    type: "name",
                    title: "Nova Base de Dados",
                    content: "Clique em Procurar para localizar o novo ficheiro da base de dados. Selecione e clique em Atualizar para atualizar a base de dados para uma versão mais recente."
                }, {
                    type: "name",
                    title: "Versão da Base de Dados",
                    content: "Mostra a versão de base de dados atual."
                }
            ]
        },
        SECURITY_FIREWALL: {
            TITLE: "Firewall",
            CONTENT: [
                {
                    type: "name",
                    title: "Firewall SPI",
                    content: "O serviço Inspeção de Pacotes Stateful (SPI) da Firewall, impede ciberataques e analisa o tráfego que está a ser transferido pelo router com base no protocolo. O SPI Firewall está ativo por defeito."
                }
            ]
        },
        SECURITY_DOS: {
            TITLE: "Proteção DoS",
            CONTENT: [
                {
                    type: "name",
                    title: "Proteção DoS",
                    content: "A Proteção DoS (Denial of Service) protege a sua rede local contra ataques DoS que a inundariam com pedidos direcionados ao servidor. Por defeito, a Proteção DoS vem desativa (Off)."
                }, {
                    type: "name",
                    title: "Filtro de ataques ICMP-FLOOD",
                    content: "Ative para impedir ataques por ICMP (Internet Control Message Protocol) inundem a sua rede local."
                }, {
                    type: "name",
                    title: "Filtro de ataques UDP-FLOOD",
                    content: "Ative para impedir ataques por UDP (User Datagram Protocol) inundem a sua rede local."
                }, {
                    type: "name",
                    title: "Filtro de ataques TCP-SYN-FLOOD",
                    content: "Ative para impedir ataques por TCP-SYN (Transmission Control Protocol-Sincronize) inundem a sua rede local.",
                    children: [
                        {
                            type: "name",
                            title: "Desligado",
                            content: "Sem proteção."
                        }, {
                            type: "name",
                            title: "BAIXO",
                            content: "Baixo nível de proteção e baixo impacto sobre o desempenho do router."
                        }, {
                            type: "name",
                            title: "Médio",
                            content: "Nível moderado de proteção e impacto semi-percetível no desempenho do router."
                        }, {
                            type: "name",
                            title: "ALTO",
                            content: "Alto nível de proteção mas impacto significativo no desempenho do router."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Ignorar Pacote Ping a partir da Porta WAN",
                    content: "Ativar para ignorar pacotes ping da porta WAN"
                }, {
                    type: "name",
                    title: "Proibir Pacote Ping a partir da Porta LAN",
                    content: "Ativar para proibir pacotes ping na porta LAN"
                }
            ]
        },
        MAC_FILTER_ALL: {
            TITLE: "Filtro MAC",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "MAC Filtering é usado para permitir ou bloquear computadores e outros dispositivos de aceder à sua rede. Quando um dispositivo é bloqueado, o mesmo não consegue se ligar ao Powerline."
                }, {
                    type: "name",
                    title: "Definições Filtro MAC",
                    children: [
                        {
                            type: "name",
                            title: "Filtro MAC",
                            content: "Mude para <b>On</b> para ativar esta funcionalidade. Se o estiver no estado desativado (Off), todos os dispositivos podem se ligar."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Selecione a regra de filtragem",
                    content: "Selecione para bloquear ou permitir que os dispositivos que surgem na Lista de dispositivos, acedam à rede Wi-Fi. Clique em <b>Guardar</b> para salvaguardar as suas configurações."
                }, {
                    type: "name",
                    title: "Lista de Dispositivos",
                    children: [
                        {
                            type: "step",
                            title: "Adicionar um dispositivo"
                        }, {
                            type: "step",
                            title: "Modificar ou remover um dispositivo",
                            content: "Clique no ícone <b>Editar</b> ou no ícone <b>Lixo</b> correspondente ao dispositivo que pretende modificar ou remover."
                        }, {
                            type: "step",
                            title: "Remover vários dispositivos na Lista de dispositivos",
                            content: "Selecione os dispositivos correspondentes a serem removidos e clique em <b>Remover</b> no topo da tabela."
                        }
                    ]
                }
            ]
        },
        MAC_FILTER: {
            TITLE: "Filtro MAC",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "MAC Filtering é usado para permitir ou bloquear computadores e outros dispositivos de aceder à sua rede. Quando um dispositivo é bloqueado, o mesmo não consegue se ligar ao Powerline."
                }, {
                    type: "name",
                    title: "Definições Filtro MAC",
                    children: [
                        {
                            type: "name",
                            title: "Filtro MAC",
                            content: "Mude para <b>On</b> para ativar esta funcionalidade. Se o estiver no estado desativado (Off), todos os dispositivos podem se ligar."
                        }
                    ]
                }
            ]
        },
        MAC_FILTER_RULES: {
            TITLE: "Selecionar Regra de Filtragem",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Selecione para bloquear ou permitir que os dispositivos que surgem na Lista de dispositivos, acedam à rede Wi-Fi. Clique em <b>Guardar</b> para salvaguardar as suas configurações."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Guardar</b> para salvaguardar as suas definições."
                }
            ]
        },
        MAC_FILTER_DEVICE_LIST: {
            TITLE: "Lista de Dispositivos",
            CONTENT: [
                {
                    type: "step",
                    title: "Adicionar um dispositivo",
                    content: ["1. Clique em <b>Adicionar</b>.", "2. Clique em <b>Ver Dispositivos</b> e escolha o endereço MAC do dispositivo na lista ou introduza manualmente o endereço MAC.", "3. Dê uma breve descrição do dispositivo.", "4. Selecione <b>Ativar esta entrada.</ B>", "5. Clique em <b>OK</b>."]
                }, {
                    type: "step",
                    title: "Modificar ou remover um dispositivo na Lista de dispositivos",
                    content: "Clique no ícone <b>Editar</b> ou no ícone <b>Lixo</b> correspondente ao dispositivo que pretende modificar ou eliminar."
                }, {
                    type: "step",
                    title: "Remover vários dispositivos na Lista de dispositivos",
                    content: "Selecione os dispositivos correspondentes a serem excluídos e clique em <b>Remover</b> no topo da tabela."
                }
            ]
        },
        WIFI_MOVE: {
            TITLE: "Wi-Fi Move",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Com a funcionalidade Wi-Fi Move ativa, todas as alterações efetuadas nas configurações Wi-Fi de um extensor Powerline serão automaticamente sincronizadas com os restantes extensores Powerline da mesma rede Powerline existente com a função Wi-Fi Move. Verifique que se estiver a usar o nome original de fábrica, por exemplo HomePlugAV, a funcionalidade Wi-Fi Move será automaticamente desativada."
                }, {
                    type: "name",
                    title: "Wi-Fi Move",
                    content: "Mude para <b>On</b> para ativar esta funcionalidade."
                }
            ]
        },
        SECURITY_LIST: {
            TITLE: "Lista de Dispositivos Bloqueados por DoS",
            CONTENT: [
                {
                    type: "name",
                    title: "Lista de Host DoS bloqueados",
                    content: "lista os endereço IP e MAC de qualquer fonte bloqueada por ataque DoS."
                }, {
                    type: "step",
                    title: "Para remover uma entrada",
                    content: "Na Lista de Dispositivos selecione a entrada que deseja excluir e clique em Apagar acima da tabela."
                }
            ]
        },
        ACCESS_CONTROL: {
            TITLE: "Controlo de Acesso",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O Controlo de acesso é usado para permitir ou bloquear acesso à sua rede a computadores específicos e outros dispositivos. Quando um dispositivo é bloqueado, ele é capaz de obter um endereço IP do router, mas incapaz de comunicar com outros dispositivos ou de se ligar à Internet."
                }, {
                    type: "paragraph",
                    content: "Para utilizar o Controle de acesso, ative esta função e especifique na Lista Negra ou Branca. Se o Controle de Acesso estiver desativado (Off), todos os dispositivos, incluindo os indicados na Lista Negra, podem se ligar."
                }
            ]
        },
        ACCESS_MODE: {
            TITLE: "Modo de Acesso",
            CONTENT: [
                {
                    type: "name",
                    title: "Lista Negra",
                    content: "Somente os dispositivos da Lista Negra serão bloqueados de aceder à sua rede."
                }, {
                    type: "name",
                    title: "Lista Branca",
                    content: "Somente os dispositivos da Lista Branca serão permitidos de aceder à sua rede."
                }
            ]
        },
        ACCESS_DEVICE: {
            TITLE: "Dispositivos Online",
            CONTENT: [
                {
                    type: "name",
                    title: "Nome de Dispositivo",
                    content: "Exibe o nome do dispositivo conectado."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Exibe o endereço IP do dispositivo conectado."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Exibe o endereço MAC do dispositivo conectado."
                }, {
                    type: "name",
                    title: "Tipo de ligação",
                    content: "Exibe o tipo de ligação do dispositivo conectado."
                }, {
                    type: "step",
                    title: "Para bloquear um dispositivo",
                    content: "Na tabela de Dispositivos Online, clique no ícone Bloquear na coluna Modificar que corresponde ao dispositivo que deseja bloquear."
                }, {
                    type: "step",
                    title: "Para bloquear vários dispositivos",
                    content: "Na tabela de Dispositivos Online, selecione todos os dispositivos que deseja bloquear e clique em Bloquear acima da tabela. O dispositivo será adicionado automaticamente aos dispositivos da Lista Negra ou Branca."
                }
            ]
        },
        ACCESS_LIST: {
            TITLE: "Dispositivos na Lista Branca/Negra",
            CONTENT: [
                {
                    type: "step",
                    title: "Para incluir na Lista Negra ou na Lista Branca de um dispositivo",
                    content: ["1. Clique no ícone Adicionar.", "2. Insira o Nome do Dispositivo.", "3. Insira o Endereço MAC do Dispositivo.", "4. Clique OK."]
                }, {
                    type: "step",
                    title: "Para modificar ou remover um dispositivo na Lista Negra/Lista Branca",
                    content: "Na tabela de Lista Negra/Lista Branca, clique no ícone Modificar ou no ícone Remover que correspondente ao dispositivo que deseja modificar ou remover."
                }, {
                    type: "step",
                    title: "Para remover vários dispositivos na Lista Negra/Lista Branca",
                    content: "Na tabela de Lista Negra/Lista Branca, selecione todos os dispositivos que deseja excluir, clique em Remover no topo da lista."
                }
            ]
        },
        IPMAC_BIND_SETTING: {
            TITLE: "Definições",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O vinculo ARP (Address Resolution Protocol) é útil para controlar o acesso de um computador específico na LAN, ligando entre si o endereço IP e o endereço MAC do dispositivo. O vinculo ARP também impede outros dispositivos de usar um endereço IP específico."
                }
            ]
        },
        IPMAC_BIND_ARP: {
            TITLE: "Lista ARP",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Exibe os endereços IP e MAC dos dispositivos ligados no momento."
                }, {
                    type: "name",
                    title: "Valor de entrada ARP",
                    content: "Exibe o número total de dispositivos que estão ligados ao router."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Exibe o endereço MAC do dispositivo conectado."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Exibe o endereço IP atribuído ao dispositivo conectado."
                }, {
                    type: "name",
                    title: "Vinculo",
                    content: "Indica se os endereços MAC e IP estão vinculados ou não."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Exibe opções para Vincular ou Apagar a entrada correspondente da lista."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Nota: Não pode vincular o mesmo endereço IP a mais de um endereço MAC."
                }
            ]
        },
        IPMAC_BIND_LIST: {
            TITLE: "Lista de Vínculos",
            CONTENT: [
                {
                    type: "step",
                    title: "Para configurar um dispositivo com vinculo ARP",
                    content: [
                        "1. Clique em Adicionar.",
                        "2. Digite o Endereço MAC do dispositivo.",
                        "3. Insira o Endereço IP que deseja vincular ao endereço MAC acima.",
                        "4. Insira uma Descrição para este dispositivo. (Opcional)",
                        "5. Selecione Ativar.",
                        "6. Clique em OK."
                    ]
                }, {
                    type: "step",
                    title: "Para modificar ou remover uma entrada",
                    content: "Na Lista de Vinculação, clique no ícone Modificar ou no ícone Remover, correspondente à entrada que deseja modificar ou remover."
                }, {
                    type: "step",
                    title: "Para remover várias entradas",
                    content: "Na Lista de Vinculação, selecione todas as entradas que deseja remover, clique em Remover no topo da lista."
                }
            ]
        },
        IPV6: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "IPv6",
                    content: "Selecione para ativar (Ligar) ou desativar (Desligar) a função IPv6 do router"
                }, {
                    type: "title",
                    title: "Tipo de ligação à Internet: IP Estático"
                }, {
                    type: "name",
                    title: "IP Estático",
                    content: "Selecione este tipo de ligação se o seu ISP assigna endereços Estáticos IPv6"
                }, {
                    type: "name",
                    title: "Endereço IPv6/Gateway Predefinido/DNS Primário/DNS Secundário",
                    content: "Digite as informações fornecidas pelo seu ISP."
                }, {
                    type: "name",
                    title: "Tamanho MTU",
                    content: "O valor MTU  (Maximum Transmission Unit) típico e predefinido para a maioria das redes Ethernet é 1500 Bytes. Não é recomendado alterar o tamanho MTU predefinido, a menos que exigido pelo ISP."
                }, {
                    type: "title",
                    title: "Tipo de ligação à Internet: IP Dinâmico"
                }, {
                    type: "name",
                    title: "IP Dinâmico",
                    content: "Selecione este tipo se o seu ISP utiliza a atribuição de endereços Dinâmicos IPv6."
                }, {
                    type: "name",
                    title: "Endereço IPv6/DNS Primário/DNS Secundário",
                    content: "Estes parâmetros são atribuídos automaticamente pelo servidor DHCPv6 do seu ISP."
                }, {
                    type: "name",
                    title: "Renovar",
                    content: "Clique neste botão para obter novos parâmetros IPv6 do servidor DHCPv6 do ISP."
                }, {
                    type: "name",
                    title: "Libertar",
                    content: "Clique neste botão para liberar todos os endereços IPv6 atribuídos pelo servidor DHCPv6 do ISP."
                }, {
                    type: "name",
                    title: "Obter Endereço IPv6",
                    content: "Selecione para \"Obter endereço não temporário IPv6\" ou \"Obter prefixo de delegação IPv6\", de acordo com o seu operador."
                }, {
                    type: "name",
                    title: "Endereço DNS",
                    content: "Selecione \"Obter dinamicamente a partir do ISP\" ou \"Utilizar o seguinte endereço DNS\". Se selecionar \"Utilizar o seguinte endereço DNS\", insira por favor o endereço de DNS fornecido pelo seu ISP."
                }, {
                    type: "name",
                    title: "DNS Primário/DNS Secundário",
                    content: "Insira parâmetros manualmente ou obtenha-os dinamicamente a partir do ISP."
                }, {
                    type: "title",
                    title: "Tipo de ligação à Internet: PPPoE"
                }, {
                    type: "name",
                    title: "PPPoE",
                    content: "Selecione este tipo se o seu ISP utiliza PPPoEv6, e fornece-lhe um Nome de Utilizador e Senha."
                }, {
                    type: "name",
                    title: "Nome de Utilizador/Senha",
                    content: "Digite os dados tal como fornecidos pelo seu ISP."
                }, {
                    type: "name",
                    title: "Endereço IPv6",
                    content: "Será atribuído automaticamente pelo servidor DHCPv6 do ISP, após introduzir o Nome de Utilizador e Senha e clicar em Conectar."
                }, {
                    type: "name",
                    title: "Endereço DNS",
                    content: "Selecione \"Obter dinamicamente a partir do ISP\" ou \"Utilizar o seguinte endereço DNS\". Se selecionar \"Utilizar o seguinte endereço DNS\", insira por favor o endereço de DNS fornecido pelo seu ISP."
                }, {
                    type: "name",
                    title: "Obter Endereço IPv6",
                    content: "Selecione \"Não temporário\" ou \"Delegação de Prefixo\" ou \"Indicado pelo ISP\", de acordo com as parametrizações do seu ISP. Se selecionar \"Indicado pelo ISP\", terá de introduzir manualmente o endereço IPv6 indicado pelo seu ISP. Se selecionar \"Não temporário\" ou \"Delegação de Prefixo\", o endereço IPv6 será automaticamente atribuído pelo servidor DHCPv6 a partir do seu ISP.",
                    children: [
                        {
                            type: "name",
                            title: "Não temporário",
                            content: "Obtenha um endereço IPv6 não-temporário através do servidor DHCPv6 do seu ISP."
                        }, {
                            type: "name",
                            title: "Prefixo de delegação",
                            content: "Obtenha um prefixo de delegação IPv6 através de um servidor DHCPv6 do seu ISP, sendo que os clientes LAN irão obter um endereço IPv6 a partir dessa delegação."
                        }, {
                            type: "name",
                            title: "Especificado pelo ISP",
                            content: "Utilize um endereço IPv6 estático indicado pelo seu ISP."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Ligar",
                    content: "Clique neste botão para obter ligação à Internet."
                }, {
                    type: "name",
                    title: "Desligar",
                    content: "Clique neste botão para desligar acesso à Internet."
                }, {
                    type: "title",
                    title: "Tipo de ligação à Internet: Túnel 6to4"
                }, {
                    type: "name",
                    title: "Túnel 6to4",
                    content: "Selecione este tipo de ligação se o seu ISP usa implementação 6to4 para a atribuição de endereços."
                }, {
                    type: "name",
                    title: "Endereço IPv4/Máscara de sub-rede IPv4/Gateway Predefinido IPv4/Endereço do Túnel",
                    content: "Estes parâmetros são gerados automaticamente pelos parâmetros IPv4 da porta WAN quando clicar em Ligar."
                }, {
                    type: "name",
                    title: "Utilize o seguinte Servidor DNS",
                    content: "Selecione esta esta caixa de seleção para ativar esta opção. De seguida introduza o DNS primário/secundário de acordo com o seu ISP."
                }, {
                    type: "name",
                    title: "Ligar",
                    content: "Clique neste botão para obter ligação à Internet."
                }, {
                    type: "name",
                    title: "Desligar",
                    content: "Clique neste botão para desligar acesso à Internet."
                }, {
                    type: "title",
                    title: "Tipo de ligação à Internet: Túnel 6RD"
                }, {
                    type: "name",
                    title: "6RD",
                    content: "Selecione este tipo se o seu ISP utiliza 6RD e lhe fornece um endereço IPv6 e prefixo de endereço IPv6."
                }, {
                    type: "name",
                    title: "Tipo de Configuração",
                    content: "Selecione o modo Auto ou Manual para configuração dos parâmetros de canal 6RD, de acordo com o seu ISP. Se os parâmetros abaixo coincidirem com os indicados pelo seu ISP, pode selecionar Auto; Caso contrário, selecione Manual e introduza os parâmetros indicados pelo seu ISP."
                }, {
                    type: "name",
                    title: "Tamanho da Máscara IPv4/Prefixo 6RD/Tamanho do prefixo 6RD/Endereço IPv4 Border Reply",
                    content: "Verifique se os valores pré-preenchidos coincidem com os fornecidos pelo seu ISP, e mantenha os valores por defeito ou introduza manualmente conforme indicado pelo seu ISP."
                }, {
                    type: "title",
                    title: "Tipo de ligação à Internet: DS-Lite"
                }, {
                    type: "name",
                    title: "DS-Lite",
                    content: "Selecione este tipo de ligação se o seu ISP usa implementação DS-Lite, com indicação do domínio AFTR e endereço IPv6, para a criação de um túnel IPv4-para-IPv6, por forma a garantir a comunicação via IPv6 sobre redes IPv4."
                }, {
                    type: "name",
                    title: "Nome AFTR",
                    content: "AFTR é acrónimo para Address Family Transition Router. Neste campo, digite o nome do domínio ou o endereço IPv6 AFTR conforme fornecido pelo seu ISP."
                }, {
                    type: "name",
                    title: "Secondary Connection",
                    content: "Selecione o tipo de conexão secundária conforme fornecido pelo seu ISP.",
                    children: [
                        {
                            type: "name",
                            title: "IP Dinâmico",
                            content: "Selecione se o seu ISP lhe fornece um IP Dinâmico como tipo de ligação secundária, sendo neste caso os parâmetros de endereço IPv6/DNS Primário/DNS Secundário atribuídos automaticamente pelo servidor DHCPv6 do ISP."
                        }, {
                            type: "name",
                            title: "IP Estático",
                            content: "Selecione este tipo de ligação se o seu ISP assigna endereços Estáticos IPv6"
                        }, {
                            type: "name",
                            title: "PPPoE",
                            content: "Selecione se o seu ISP lhe fornece uma ligação PPPoE como tipo de ligação secundária, e introduza o Nome de Utilizador/Senha. O endereço IPv6 será atribuído pelo seu ISP após clicar no botão Ligar."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Tipo de ligação à Internet: Pass Through (Bridge)"
                }, {
                    type: "paragraph",
                    content: "Selecione este tipo de ligação se o seu ISP utiliza Pass Through (Bridge). Neste caso, não é necessário qualquer tipo de configuração."
                }
            ]
        },
        IPV6_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Excepto para o modo Pass Through (Bridge), os outros 6 tipos de ligação à Internet requerem configurações para os parâmetros IPv4 LAN em simultâneo."
                }, {
                    type: "name",
                    title: "Tipo Assignado",
                    content: "Escolha o mais adequado de acordo com o seu ISP.",
                    children: [
                        {
                            type: "name",
                            title: "DHCPv6",
                            content: "Para atribuir endereços IP automaticamente aos clientes na LAN.",
                            children: [
                                {
                                    type: "name",
                                    title: "Prefixo de Endereço",
                                    content: "Digite o prefixo de endereço conforme fornecido pelo seu ISP."
                                }, {
                                    type: "name",
                                    title: "Tempo para Libertar",
                                    content: "Corresponde ao tempo durante o qual o endereço IP atribuído permanece válido."
                                }, {
                                    type: "name",
                                    title: "Endereço",
                                    content: "Endereço IP atribuído automaticamente pelo servidor DHCPv6 do ISP."
                                }
                            ]
                        }, {
                            type: "name",
                            connector: " ",
                            title: "SLAAC + Stateless DHCP",
                            children: [
                                {
                                    type: "name",
                                    title: "Prefixo de Endereço",
                                    content: "Digite o prefixo de endereço conforme fornecido pelo seu ISP."
                                }, {
                                    type: "name",
                                    title: "Endereço",
                                    content: "Endereço IP atribuído automaticamente pelo servidor DHCPv6 do ISP."
                                }
                            ]
                        }, {
                            type: "name",
                            connector: " ",
                            title: "SLAAC + RDNSS",
                            children: [
                                {
                                    type: "name",
                                    title: "Prefixo de Endereço",
                                    content: "Digite o prefixo de endereço conforme fornecido pelo seu ISP."
                                }, {
                                    type: "name",
                                    title: "Endereço",
                                    content: "Endereço IP atribuído automaticamente pelo servidor DHCPv6 do ISP."
                                }
                            ]
                        }
                    ]
                }
            ]
        },
        IPV6_MAC_CLONE: {
            TITLE: "Clonar MAC",
            CONTENT: [
                {
                    type: "name",
                    title: "Usar Endereço MAC Predefinido",
                    content: "Não altera o endereço MAC predefinido do router, caso o ISP não assigne o endereço IP vinculado a endereço MAC especifico."
                }, {
                    type: "name",
                    title: "Usar Endereço MAC deste Computador",
                    content: "Selecione para copiar o endereço MAC do computador que é ligado ao router, caso o ISP vincule o endereço IP atribuído ao endereço MAC deste computador."
                }, {
                    type: "name",
                    title: "Endereço MAC Personalizado",
                    content: "Digite o endereço MAC manualmente, caso o ISP vincule o endereço IP atribuído a um endereço MAC específico."
                }
            ]
        },
        TIME_SETTING: {
            TITLE: "Definições de Tempo",
            CONTENT: [
                {
                    type: "step",
                    title: "Para sincronizar automaticamente a hora",
                    content: ["1. Selecione o <b>Fuso Horário</b> a partir da lista.", "2. No campo <b>Servidor NTP I</b>, introduza o endereço IP do servidor NTP pretendido. (Opcional)", "3. No campo <b>Servidor NTP II</b>, introduza o endereço IP do servidor NTP pretendido. (Opcional)", "4. Clique <b>Obter GMT</b>."]
                }, {
                    type: "step",
                    title: "Para configurar manualmente a data e hora",
                    content: ["1. No campo <b>Definições horárias</b>, selecione o seu <b>Fuso horário</b> local.", "2. Introduza a <b>Data</b> atual.", "3. Selecione o <b>Hora</b> (No formato de 24 horas).", "4. Clique em <b>Guardar</b>."]
                }
            ]
        },
        TIME_SETTING_DAYLIGHT: {
            TITLE: "Hora de Verão",
            CONTENT: [
                {
                    type: "step",
                    title: "Para configurar a Hora de Verão",
                    content: ["1. Selecione <b>Ativar Hora de Verão</b>.", "2. Selecione a data e hora de <b>Inicio</b> para começar a Hora de Verão.", "3. Selecione a data e hora de <b>Fim</b> para terminar a Hora de Verão.", "4. Clique em <b>Guardar</b>."]
                }
            ]
        },
        DIGNOSTIC: {
            TITLE: "Diagnósticos",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O Router fornece ferramentas de Ping e Traceroute que o ajudam a diagnosticar problemas de conectividade na rede. A Ferramenta de Ping envia pacotes para um endereço IP ou domínio e regista os resultados, tais como o numero de pacotes envidados e recebidos, e tempos de resposta. A ferramenta de Traceroute envia pacotes para um endereço IP ou nome de domínio e apresenta o número de saltos (hops) e tempo para um determinado destino de rede."
                }, {
                    type: "paragraph",
                    content: "Pode utilizar o ping e o traceroute para testar a conetividade com dispositivo na rede local, por endereço IP ou nome de domínio."
                }, {
                    type: "step",
                    title: "Para diagnosticar utilizando Ping",
                    content: ["1. Digite o Endereço IP de destino ou Nome de Domínio.", "2. Clique na seta do ícone para abrir o menu Avançado e especificar a Contagem Ping e Tamanho Pacote Ping. (Opcional)", "3. Clique em Iniciar."]
                }, {
                    type: "step",
                    title: "Para diagnosticar utilizando Traceroute",
                    content: ["1. Digite o Endereço IP de destino ou Nome de Domínio.", "2. Clique no ícone Seta para abrir o menu Avançado e especificar o número de saltos (hops) até ao destino no campo Max TTL Traceroute (Time to Live). Por defeito é 20. (Opcional)", "3. Clique em Iniciar."]
                }
            ]
        },
        FIRMWARE: {
            TITLE: "Atualização de firmware",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Antes de atualizar o firmware do extensor Powerline, terá de descarregar o firmware mais recente a partir da página de <a class=\"link\" href=\"http://www.tp-link.com/pt/support/\" target=\"_blank\">Suporte TP-LINK</a> para o seu computador."
                }, {
                    type: "step",
                    title: "IMPORTANTE: Para evitar qualquer falha durante o processo de atualização, por favor leia o seguinte:",
                    content: ["Certifique-se que a última versão de firmware é a indicada para a versão de hardware do produto (como apresentado na página de atualização de firmware).", "Certifique-se que possui uma ligação de rede estável entre o seu PC e o extensor Powerline. NÃO é recomendada a atualização de firmware via Wi-Fi.", "Cópia de Segurança do seu Extensor Powerline.", "NÃO Desligue o extensor Powerline durante a atualização de firmware."]
                }, {
                    type: "step",
                    title: "Para atualizar o firmware do Extensor Powerline",
                    content: ["1. Click <b>Procurar</b>.", "2. Localize e selecione o ficheiro de firmware descarregado.", "3. Clique <b>Atualizar</b>."]
                }, {
                    type: "paragraph",
                    content: "O processo de atualização demora alguns minutos a ficar completo. Por favor NÃO desligue o Extensor Powerline durante o processo de atualização."
                }
            ]
        },
        FIRMWARE_UPGRADE_ONLINE: {
            TITLE: "Para atualizar o firmware Online",
            CONTENT: [
                {
                    type: "paragraph",
                    content: ["Clique em Atualizar e clique em Sim quando solicitado, em seguida o extensor irá baixar o firmware mais recente automaticamente e atualizar. Você também pode clicar em Verificar para buscar  versões mais recentes."]
                }
            ]
        },
        FIRMWARE_UPGRADE: {
            TITLE: "Para atualizar o firmware manualmente",
            CONTENT: [
                {
                    type: "step",
                    content: ["1. Clique em Suporte no rodapé da página e descarregue o firmware mais recente para o seu Computador. Por favor, certifique-se que o ficheiro de firmware que irá descarregar corresponde à versão de hardware do seu Router, como indicado na página.", "2. Clique em Procurar e selecione o ficheiro de firmware.", "3. Clique em Atualizar."]
                }, {
                    type: "paragraph",
                    content: ["A atualização de firmware leva alguns minutos. O extensor irá reiniciar automaticamente quando a atualização se encerrar."]
                }
            ]
        },
        BACKUP: {
            TITLE: "Cópia de Segurança",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "É altamente recomendado efetuar uma cópia das configurações atuais, caso seja necessário repor as configurações para um determinado estado anterior, ou no caso da reposição dos valores de fábrica."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Cópia de Segurança</b> para guardar as configurações atuais para o seu Computador. Certifique-se que guarda o ficheiro de configuração numa localização segura para que, em caso necessidade, possa repor o Extensor para o estado anterior."
                }
            ]
        },
        RESTORE: {
            TITLE: "Repor",
            CONTENT: [
                {
                    type: "step",
                    title: "Para repor a partir de cópia de segurança",
                    content: ["1. Clique em <b>Procurar</b>.", "2. Localize e selecione o ficheiro de Cópia de Segurança.", "3. Clique em <b>Repor</b>."]
                }
            ]
        },
        FACTORY: {
            TITLE: "Reposição dos valores de fábrica",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Clique em <b>Repor Valores de Fábrica</b> para repor dos valores de fábrica do seu Extensor Powerline."
                }, {
                    type: "note",
                    title: "Nota",
                    content: ["1. A Restauração de Fábrica irá apagar todas as configurações feitas no extensor. Para fazer o login na página de gerenciamento novamente, utilize o padrão  <b>admin</b> para nome de usuário e senha.", "2. Favor NÃO desligar o extensor durante o processo de backup ou restauração."]
                }
            ]
        },
        ADMIN_ACCOUNT: {
            TITLE: "Gestão de Contas",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Esta página permite-lhe alterar o seu Nome de Utilizador e/ou Senha de inicio de sessão."
                }, {
                    type: "name",
                    title: "Utilizador Anterior",
                    content: "Digite seu nome de utilizador atual."
                }, {
                    type: "name",
                    title: "Senha Anterior",
                    content: "Digite sua senha atual."
                }, {
                    type: "name",
                    title: "Novo Utilizador",
                    content: "Digite o seu novo nome de utilizador."
                }, {
                    type: "name",
                    title: "Nova Senha",
                    content: "Digite a nova senha."
                }, {
                    type: "name",
                    title: "Confirmar Nova Senha",
                    content: "Digite a nova senha novamente."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Caso tenha alterado o Nome de Utilizar e Senha atuais do Extensor Powerline, certifique-se que as novas informações de inicio de sessão são guardadas num local seguro. Uma Senha segura deverá conter pelo menos 8 ou mais caracteres, combinando letras maiúsculas ou minúsculas, números e pontuação."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Guardar</b> para guardar todas as suas configurações."
                }
            ]
        },
        ADMIN_RECOVERY: {
            TITLE: "Recuperação da Senha",
            CONTENT: [
                {
                    type: "name",
                    title: "Ativar Recuperação de Senha",
                    content: "É altamente recomendável ativar a função de recuperação da senha, que lhe envia nome de utilizador e senha perdida ou esquecida por e-mail."
                }, {
                    type: "name",
                    title: "De",
                    content: "Insira endereço e-mail válido para ser usado para enviar e-mails."
                }, {
                    type: "name",
                    title: "Para",
                    content: "Insira endereço e-mail válido para ser usado para receber e-mail."
                }, {
                    type: "name",
                    title: "Servidor SMTP",
                    content: "Insira o endereço do servidor SMTP que o Router usa para enviar as informações da conta via e-mail."
                }, {
                    type: "name",
                    title: "Ativar Autenticação",
                    content: "Selecione Autenticação se o servidor de email de saída requer autenticação para enviar email, sendo necessário preencher o Nome de Utilizador e Senha nos campos correspondentes. Estes campos são sensíveis a letras maiúsculas ou minúsculas."
                }
            ]
        },
        ADMIN_LOCAL: {
            TITLE: "Gestão Local",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Esta seção permite-lhe limitar o número de dispositivos da rede local que podem aceder ao router, usando autenticação baseada em endereço MAC."
                }, {
                    type: "name",
                    title: "Acesso para Todos os Dispositivos Conectados à LAN",
                    content: "Mude para Ligado para ativar a gestão a todos os dispositivos de LAN conectados ou Desligado para permitir a gestão para um dispositivo específico."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Exibe o endereço MAC do dispositivo de acesso limitado."
                }, {
                    type: "name",
                    title: "DESCRIÇÃO",
                    content: "Exibe a descrição do dispositivo de acesso limitado."
                }, {
                    type: "name",
                    title: "ESTADO",
                    content: "Exibe o status atual do dispositivo de acesso limitado (ativado ou desativado)."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Exibe opções para Modificar e Apagar um dispositivo correspondente da lista."
                }, {
                    type: "step",
                    title: "Para adicionar um dispositivo cliente à lista",
                    content: ["1. Clique em Adicionar.", "2. Clique em Ver Dispositivos Existentes para escolher um dispositivo existente ou digite o endereço MAC de um dispositivo no campo Endereço MAC.", "3. Introduza a Descrição para o dispositivo. (Opcional)", "4. Selecione Ativar.", "5. Clique em OK."]
                }, {
                    type: "step",
                    title: "Para modificar ou eliminar um dispositivo na lista",
                    content: "Clique no ícone Modificar ou no ícone Apagar correspondente ao Dispositivo que pretende modificar ou eliminar."
                }, {
                    type: "step",
                    title: "Para eliminar múltiplos dispositivos",
                    content: "Selecione todos os dispositivos que deseja excluir e clique em Apagar."
                }
            ]
        },
        ADMIN_REMOTE: {
            TITLE: "Restão Remota",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A função de Gestão Remota permite aceder e configurar o router remotamente a partir da Internet."
                }, {
                    type: "name",
                    title: "Desativar Gestão Remota",
                    content: "Selecione esta opção para desativar a gestão remota."
                }, {
                    type: "name",
                    title: "Ativar Gestão Remota para Todos os Dispositivos",
                    content: "Selecione esta opção para ativar a gestão remota para todos os endereços IP. Se selecionado, configurar o campo Porta de Gestão WEB."
                }, {
                    type: "name",
                    title: "Ativar Gestão Remota para Dispositivos Específicos",
                    content: "Selecione esta opção para ativar a gestão remota a partir de um endereço IP específico. Se selecionado, configure os campos de Porta de Gestão WEB e Endereço IP de Gestão Remota."
                }, {
                    type: "name",
                    title: "Porta de Gestão WEB",
                    content: "Introduza o número da porta, entre 1024 e 65535, a ser utilizado para aceder à página de gestão Web do Router com maior segurança. Tipicamente, os Navegadores Web utilizam a porta standard de serviço HTTP 80. A porta de serviço padrão e comum é 8080, que é uma porta alternativa de serviço para o HTTP."
                }, {
                    type: "name",
                    title: "Endereço IP de Gestão Remota",
                    content: "Introduza um endereço de IP válido ou um intervalo de IP com permissão para acederem ao Router. Se 255.255.255.255 for introduzido, todos os utilizadores serão permitidos."
                }
            ]
        },
        SYSTEM_LOG: {
            TITLE: "Registo de Sistema",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O Registo de Sistema exibe uma lista das mais recentes atividades (eventos) do Extensor. Poderá definir que tipo de Registos e/ou níveis de Registo pretende ver."
                }, {
                    type: "name",
                    title: "Tipo",
                    content: "Selecione o tipo de registo de eventos do sistema a exibir."
                }, {
                    type: "name",
                    title: "Nível",
                    content: "Selecione o nível de log do sistema para exibir."
                }, {
                    type: "name",
                    title: "Atualizar",
                    content: "Clique neste ícone para atualizar o registro do sistema."
                }, {
                    type: "name",
                    title: "Apagar Tudo",
                    content: "Clique neste ícone para apagar todos os registros do sistema."
                }, {
                    type: "name",
                    title: "Gravar Registo",
                    content: "Clique neste botão para descarregar o Registo de Sistema para o seu Computador."
                }
            ]
        },
        TRAFFIC_STATISTIC: {
            TITLE: "Estatísticas de Tráfego",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A página de Estatísticas de Tráfego exibe o tráfego de rede LAN, WAN e WLAN pacotes enviados e recebidos."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Se o NAT Boost estiver ativado, as Estatísticas de Tráfego devem ser desativadas."
                }, {
                    type: "name",
                    title: "Estatísticas de Tráfego",
                    content: "Por padrão, as Estatísticas de Tráfego estão Desligadas. Para exibir a informação de estatística, clique em Ligar(ON)."
                }
            ]
        },
        TRAFFIC_STATISTIC_LIST: {
            TITLE: "Lista de Estatísticas de Tráfego",
            CONTENT: [
                {
                    type: "name",
                    title: "Endereço IP/Endereço MAC",
                    content: "Exibe o endereço IP e endereço MAC do dispositivo cliente associado."
                }, {
                    type: "name",
                    title: "Total de Pacotes",
                    content: "Exibe o número total de pacotes transmitidos e recebidos pelo dispositivo cliente desde o início da sessão ou da última reposição do contador."
                }, {
                    type: "name",
                    title: "Total de Bytes",
                    content: "Exibe o número total de bytes transmitidos e recebidos pelo dispositivo cliente desde o início da sessão ou da última reposição do contador."
                }, {
                    type: "name",
                    title: "Pacotes Atuais",
                    content: "Exibe o número atual de pacotes transmitidos e recebidos num intervalo de tempo específico."
                }, {
                    type: "name",
                    title: "Bytes Atuais",
                    content: "Exibe o número atual de bytes transmitidos e recebidos em um intervalo de tempo específico."
                }, {
                    type: "name",
                    title: "ICMP Tx Atual",
                    content: "Exibe a Taxa de Transmissão atual e a taxa máxima de transmissão de pacotes ICMP transmitidos através da porta WAN por segundo."
                }, {
                    type: "name",
                    title: "UDP Tx Atual",
                    content: "Exibe a Taxa de Transmissão atual e a taxa máxima de transmissão de pacotes UDP transmitidos através da porta WAN por segundo."
                }, {
                    type: "name",
                    title: "SYN Tx Atual",
                    content: "Exibe a Taxa de Transmissão atual e a taxa máxima de transmissão de pacotes TCP SYN transmitidos através da porta WAN por segundo."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Exibe opções para Repor (a zero) e Apagar a estatística correspondente da lista."
                }, {
                    type: "name",
                    title: "Atualizar",
                    content: "Clique para atualizar a informação estatística sobre a página."
                }, {
                    type: "name",
                    title: "Repor Tudo",
                    content: "Clique para repor todos os valores estatísticos na lista para zero."
                }, {
                    type: "name",
                    title: "Apagar Tudo",
                    content: "Clique para apagar todas as informações estatísticas na lista."
                }
            ]
        },
        SYSTEM_PARA_WIRELESS: {
            TITLE: "Wi-Fi 2.4GHz/5GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Intervalo de Beacon",
                    content: "Insira um valor entre 40 e 1000, em milissegundos, para determinar a duração entre pacotes de Beacon que são transmitidos pelo Router para sincronizar a rede sem fio. O valor predefinido é 100 milissegundos."
                }, {
                    type: "name",
                    title: "RTS Threshold",
                    content: "Introduza um valor entre 1 e 2346 para determinar o tamanho do pacote de transmissão de dados a passar pelo Router. Por defeito, o tamanho do RTS (Request to Send) Threshold é de 2346. Caso o tamanho do pacote exceda o valor de threshold, o Router envia pacotes Request to Send para um dispositivo em particular e negoceia o envio de pacotes de dados, ou caso contrário o pacote é enviado de imediato."
                }, {
                    type: "name",
                    title: "Intervalo DTIM",
                    content: "Esse valor determina o intervalo da Delivery Traffic Indication Message (DTIM). Insira um valor entre 1 e 15 em milissegundos. O valor predefinido é 1, que indica que o intervalo DTIM é igual ao Intervalo Beacon."
                }, {
                    type: "name",
                    title: "Group Key Update Period",
                    content: "Digite o número de segundos (mínimo de 30) para controlar o intervalo de tempo para renovação automática da chave de encriptação. Por defeito é 0, indicando que não há renovação de chave."
                }, {
                    type: "name",
                    title: "Função WMM",
                    content: "A função WMM garante que os pacotes com mensagens de alta prioridade serão  transmitidos preferencialmente. Está ativo por defeito e é altamente recomendado."
                }, {
                    type: "name",
                    title: "Função Short GI",
                    content: "Esta função está ativada por defeito e é recomendada para aumentar a capacidade de transferência de dados, reduzindo o tempo de Guard Interval (GI)."
                }, {
                    type: "name",
                    title: "Função Isolamento AP",
                    content: "Por defeito, esta função está desativada. Caso pretenda bloquear a comunicação entre dispositivos Wi-Fi ligados na sua rede, mas manter na mesma o acesso à internet, selecione a opção Ativar Isolamento AP."
                }, {
                    type: "name",
                    title: "Bridging WDS",
                    content: "Ative a funcionalidade Bridging WDS (Wireless Distribution System) para permitir que o Router se ligue com outro ponto de acesso (AP) numa rede local sem fio (WLAN). Se esta função for ativada, configure o seguinte:",
                    children: [
                        {
                            type: "name",
                            title: "SSID",
                            content: "Introduza o SSID do WAP (Wireless Access Point) ao qual o Router se irá ligar como Cliente ou utilize a função de site Survey para detectar as redes disponíveis."
                        }, {
                            type: "name",
                            title: "Pesquisa",
                            content: "Clique neste botão para pesquisar e exibir o SSID, BSSID, potência do sinal, canal e informações de segurança de todas as redes Wi-Fi disponíveis dentro do alcance. Quando selecionar uma rede, os campos SSID, MAC Address e Segurança serão preenchidos automaticamente."
                        }, {
                            type: "name",
                            title: "Endereço MAC (a ser bridged)",
                            content: "Introduza o endereço MAC (BSSID) no formato de 12 caracteres hexadecimais (0-9, a-f, A-F) separado por hífens, do ponto de acesso Wi-Fi ao qual o Router se vai ligar como cliente. Ao selecionar o AP através do Survey, o campo Endereço MAC é preenchido automaticamente."
                        }, {
                            type: "name",
                            title: "Segurança",
                            content: "Selecione o tipo segurança correto, de acordo com a segurança do ponto de acesso selecionado, Nenhuma, WPA-PSK / WPA2-PSK ou WEP. Se você escolher o AP desejado através do recurso de Pesquisa, o campo de segurança é automaticamente preenchido.",
                            children: [
                                {
                                    type: "name",
                                    title: "Senha",
                                    content: "Esta opção está disponível quando o tipo de segurança é WPA-PSK / WPA2-PSK ou WEP. Digite a senha de segurança do AP selecionado."
                                }, {
                                    type: "name",
                                    title: "Tipo de Autenticação",
                                    content: "Esta opção só está disponível quando o tipo de segurança é WEP (Wired Equivalent Privacy). Selecione o tipo de autenticação adequado (Auto, Sistema Aberto ou Chave Partilhada) utilizada no AP selecionado."
                                }, {
                                    type: "name",
                                    title: "Formato de Chave WEP",
                                    content: "Esta opção só está disponível quando o tipo de segurança é WEP. Selecione o formato de chave (ASCII ou Hexadecimal) usado no AP selecionado."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "paragraph",
                    content: "Clique Guardar para salvar as suas definições."
                }
            ]
        },
        SYSTEM_PARA_WPS: {
            TITLE: "WPS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Selecione Ativar WPS na caixa de seleção e clique em Guardar para ativar a função WPS (Wi-Fi Protected Setup), que lhe permite configurar e ligar facilmente dispositivos com a função WPS."
                }
            ]
        },
        SYSTEM_PARA_NAT: {
            TITLE: "NAT",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Selecione a opção Ativar NAT e clique em Gravar para ativar a função NAT (Network Address Translation)."
                }, {
                    type: "name",
                    title: "NAT Boost",
                    content: "Selecione a opção Ativar NAT Boost e clique em Gravar para garantir que o seu router tem o melhor desempenho."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "NAT Boost será desativado quando o QoS e Estatísticas de tráfego estiverem ativas em simultâneo."
                }
            ]
        },
        SYSTEM_PARA_DOS: {
            TITLE: "Definições de Níveis de proteção DoS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O Nível de Proteção DoS protege o seu Router contra ataques de TCP-SYN-Flood, UDP-Flood e ICMP-Flood."
                }, {
                    type: "name",
                    title: "Nível de Pacotes ICMP-FLOOD",
                    content: "Insira um valor entre 5 e 7.200 pacotes ICMP para acionar a proteção ICMP-FLOOD imediatamente quando o número de pacotes exceder o valor limite pré-definido."
                }, {
                    type: "name",
                    title: "Nível de Pacotes UDP-FLOOD",
                    content: "Insira um valor entre 5 e 7.200 pacotes UDP para acionar a proteção UDP-FLOOD imediatamente quando o número de pacotes exceder o valor limite pré-definido."
                }, {
                    type: "name",
                    title: "Nível de Pacotes TCP-FLOOD",
                    content: "Insira um valor entre 5 e 7.200 pacotes TCP-SYN para acionar a proteção TCP-SYN-FLOOD imediatamente quando o número de pacotes exceder o valor limite pré-definido."
                }, {
                    type: "paragraph",
                    content: "Clique em Guardar para guardar as configurações."
                }
            ]
        },
        SYSTEM_PARA_DUPLEX: {
            TITLE: "Duplex",
            CONTENT: [
                {
                    type: "name",
                    title: "Duplex",
                    content: "Selecione o tipo duplex a partir da lista."
                }, {
                    type: "paragraph",
                    content: "Clique em Guardar para guardar as configurações."
                }
            ]
        },
        BASIC_NETWORK_INTEREST: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "Status da Internet",
                    content: "Mostra o Status atual da ligação à Internet do Router"
                }, {
                    type: "name",
                    title: "Tipo de ligação",
                    content: "Mostra o tipo de ligação à Internet."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Mostra o atual endereço IP de Internet atribuído ao router."
                }, {
                    type: "name",
                    title: "Ligação Secundária / Endereço IP",
                    content: "Mostra o tipo de ligação secundária e endereço IP."
                }
            ]
        },
        BASIC_NETWORK_ROUTER: {
            TITLE: "Router",
            CONTENT: [
                {
                    type: "title",
                    title: "Wi-Fi 2.4GHz/5GHz"
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Mostra o nome da rede Wi-Fi atual nas bandas de frequência 2.4GHz/5GHz."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Mostra o canal Wi-Fi em que estão a emitir os rádios 2.4GHz/5GHz."
                }, {
                    type: "name",
                    title: "MAC:",
                    content: "Mostra o endereço MAC das redes Wi-Fi 2.4GHz/5GHz."
                }, {
                    type: "title",
                    title: "Rede Wi-Fi 2.4GHz/5GHz"
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Mostra se a rede s Wi-Fi de Convidados 2.4GHz/5GHz está Ligada (ativada) ou Desligada (desativada)."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Mostra o nome da rede Wi-Fi  de Convidados."
                }
            ]
        },
        BASIC_NETWORK_CLIENTS: {
            TITLE: "Clientes Com fios / Sem fios",
            CONTENT: [
                {
                    type: "name",
                    title: "Nome",
                    content: "Mostra o nome do cliente conectado ao router."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Mostra o endereço IP atribuído ao cliente."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Mostra o endereço MAC do cliente."
                }
            ]
        },
        BASIC_NETWORK_PRINTER: {
            TITLE: "Impressora",
            CONTENT: [
                {
                    type: "name",
                    title: "Nome",
                    content: "Mostra o nome da impressora ligada ao router através da porta USB."
                }
            ]
        },
        BASIC_NETWORK_USB: {
            TITLE: "Disco USB",
            CONTENT: [
                {
                    type: "name",
                    title: "Disco USB",
                    content: "Exibe a marca do dispositivo USB ligado ao Router."
                }, {
                    type: "name",
                    title: "Total",
                    content: "Exibe o volume total do disco USB."
                }, {
                    type: "name",
                    title: "Disponível",
                    content: "Exibe o espaço disponível do disco USB."
                }
            ]
        },
        BASIC_INTERNET: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "Detetar Automaticamente",
                    content: "Clique neste botão para o router detetar automaticamente o atual tipo de ligação à Internet."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Nota: Se não tiver certeza de qual o tipo de ligação à Internet, use a função de Deteção Automática ou contacte o seu ISP para obter assistência."
                }, {
                    type: "title",
                    title: "Tipo de ligação à Internet: IP Estático"
                }, {
                    type: "name",
                    title: "Endereço IP/Máscara de Rede/Gateway Predefinido/DNS Primário/DNS Secundário",
                    content: "Digite as informações fornecidas pelo seu ISP."
                }, {
                    type: "title",
                    title: "Tipo de ligação à Internet: IP Dinâmico"
                }, {
                    type: "name",
                    title: "NÃO Clonar Endereço MAC/Clonar endereço MAC atual do Computador",
                    content: "Selecione se deseja clonar o endereço MAC ou não, de acordo com as instruções do seu ISP."
                }, {
                    type: "title",
                    title: "Tipo de ligação à Internet: PPPoE"
                }, {
                    type: "name",
                    title: "Nome de Utilizador/Senha",
                    content: "Digite o nome de utilizador e senha fornecidos pelo seu ISP. Estes campos são sensíveis a caracteres em maiúsculas e minúsculas."
                }, {
                    type: "title",
                    title: "Tipo de ligação à Internet: L2TP/PPTP"
                }, {
                    type: "name",
                    title: "Nome de Utilizador/Senha",
                    content: "Digite o nome de utilizador e senha fornecidos pelo seu ISP. Estes campos são sensíveis a caracteres em maiúsculas e minúsculas."
                }, {
                    type: "name",
                    title: "Ligação Secundária (IP Dinâmico ou Estático)",
                    children: [
                        {
                            type: "name",
                            title: "IP Dinâmico",
                            content: "Selecione se o endereço IP e Máscara de Rede são atribuídos automaticamente pelo ISP."
                        }, {
                            type: "name",
                            title: "IP Estático",
                            content: "Selecione se o endereço IP, Máscara de Rede, Gateway e endereço de DNS são fornecidos pelo seu ISP, e introduza de seguida esses valores nos campos correspondentes."
                        }
                    ]
                }, {
                    type: "name",
                    title: "IP do Servidor VPN/Nome de Domínio",
                    content: "Introduza o Endereço IP do Servidor VPN ou nome de domínio fornecido pelo seu ISP."
                }
            ]
        },
        BASIC_WIRELESS: {
            TITLE: "Definições Wi-Fi",
            CONTENT: [
                {
                    type: "name",
                    title: "Ativar Rádio Wi-Fi",
                    content: "Selecione esta opção para ativar os rádios Wi-Fi das frequências 2.4GHz/5GHz."
                }, {
                    type: "name",
                    title: "Nome de Rede Wi-Fi (SSID)",
                    content: "Pode deixar o nome da rede Wi-Fi (SSID) predefinido ou introduzir um novo nome (até 32 caracteres). Este campo é sensível a caracteres em maiúsculas e minúsculas."
                }, {
                    type: "name",
                    title: "Ocultar SSID",
                    content: "Selecione esta opção para ocultar o nome da rede 2.4GHz/5GHz (SSID) da lista de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Senha",
                    content: "Introduza uma senha Wi-Fi com 8 a 63 caracteres ASCII, ou entre 8 a 64 caracteres hexadecimais neste campo (sensível a letras maiúsculas ou minúsculas)."
                }
            ]
        },
        BASIC_DEVICE_SETTINGS: {
            TITLE: "Definições do Dispositivo",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A página de Definições de Dispositivo mostra a informação relativa a qualquer dispositivo de armazenamento USB conectado via porta USB."
                }, {
                    type: "name",
                    title: "Examinar",
                    content: "Normalmente, o Router deteta automaticamente qualquer dispositivo recentemente conectado. Se tal não suceder, clique no botão Examinar para procura qualquer novo dispositivo conectado e refrescar a página com informações atualizadas."
                }, {
                    type: "name",
                    title: "Volume",
                    content: "Mostra o nome do volume USB."
                }, {
                    type: "name",
                    title: "Capacidade",
                    content: "Mostra a capacidade de armazenamento total do dispositivo USB."
                }, {
                    type: "name",
                    title: "Espaço Livre",
                    content: "Mostra o espaço de armazenamento atualmente disponível."
                }, {
                    type: "name",
                    title: "Remover em Segurança",
                    content: "Clique nesse botão para desmontar de forma segura o dispositivo de armazenamento USB antes de desconectá-lo fisicamente da porta USB do router.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Tenha em atenção que o botão para Remover com Segurança apenas é exibido quando existe um dispositivo USB ligado no Router. Caso o disco USB esteja em utilização também não poderá Remover o Dispositivo em Segurança."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Ativo",
                    content: "Esta opção só aparece quando há um dispositivo de armazenamento USB conectado ao router. Selecione para ativar a partilha do conteúdo do dispositivo USB."
                }
            ]
        },
        BASIC_SHARING_SETTINGS: {
            TITLE: "Definições de Partilha",
            CONTENT: [
                {
                    type: "name",
                    title: "Nome de Servidor de Rede/Media",
                    content: "Mostra o nome usado para aceder ao dispositivo de armazenamento USB conectado."
                }
            ]
        },
        BASIC_FOLDER_SHARING: {
            TITLE: "Partilha de Pastas",
            CONTENT: [
                {
                    type: "name",
                    title: "Partilha Tudo",
                    content: "Mude para Ligado para partilhar todas as pastas e ficheiros ou mantenha Desligado para partilhar somente pastas especificas."
                }, {
                    type: "name",
                    title: "Ativar Autenticação",
                    content: "É altamente recomendável ativar a autenticação, para exigir que os utilizadores insiram um nome de utilizador e senha válidos para acederem às pastas partilhadas."
                }, {
                    type: "name",
                    title: "Nome de Pasta",
                    content: "Mostra o nome da pasta partilhada."
                }, {
                    type: "name",
                    title: "Caminho para Pasta",
                    content: "Mostra o caminho para a pasta partilhada."
                }, {
                    type: "name",
                    title: "Partilha de Media",
                    content: "Indica se a pasta partilhada permite ou não a partilha de conteúdos multimédia."
                }, {
                    type: "name",
                    title: "Nome de Volume",
                    content: "Exibe o nome do volume partilhado."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Exibe o estado da pasta partilhada através ícone Lâmpada. Verde (ligado) significa que está ativo e cinzento (desligado) apresenta o estado Desligado. Poderá ativar ou desativar ao clicar no ícone Lâmpada."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Mostra opções para Modificar e Apagar a pasta partilhada correspondente."
                }, {
                    type: "name",
                    title: "Adicionar",
                    content: "Clique neste botão para criar uma nova entrada."
                }, {
                    type: "name",
                    title: "Apagar",
                    content: "Clique neste botão para remover da tabela a entrada selecionada."
                }, {
                    type: "name",
                    title: "Procurar",
                    content: "Clique para procurar uma pasta partilhada."
                }, {
                    type: "name",
                    title: "Permite Acesso de Convidados de Rede",
                    content: "Selecione para permitir que clientes da Rede de Convidados possam aceder às pastas partilhadas."
                }, {
                    type: "name",
                    title: "Ativar Autenticação",
                    content: "Selecionar para obrigar os utilizadores a terem um nome de utilizador e senha válidos para acederem às pastas partilhadas."
                }, {
                    type: "name",
                    title: "Ativar Acesso de Escrita",
                    content: "Selecione para permitir que os utilizadores façam alterações no conteúdo da pasta."
                }, {
                    type: "name",
                    title: "Ativar Partilha de Media",
                    content: "Selecione para ativar a partilha de Média."
                }
            ]
        },
        BASIC_PRINT_SERVER: {
            TITLE: "Servidor de Impressão",
            CONTENT: [
                {
                    type: "name",
                    title: "Ativar Servidor de Impressão",
                    content: "Clique em Ligar (On) para ativar a função de Servidor de Impressão."
                }, {
                    type: "name",
                    title: "Nome de Impressora",
                    content: "Mostra o nome da impressora conectada ao router."
                }, {
                    type: "step",
                    title: "Para configurar um Servidor de Impressão que pode ser utilizado na sua rede",
                    content: ["1. Ligue uma impressora USB à porta USB do router com recurso a um cabo USB.", "2. Instale o servidor de impressão no seu Computador. Consulte o manual do seu PC para mais informações.", "3. Instale o Utilitário de impressão USB TP-Link a partir do CD de Instalação (apenas para Windows) ou descarregue (para Windows e MAC OS X) a partir do site oficial da TP-Link."]
                }
            ]
        },
        BASIC_PARENTAL_CONTROL: {
            TITLE: "Controlo Parental",
            CONTENT: [
                {
                    type: "name",
                    title: "Estado",
                    content: "Selecione para ativar a função de Controlo Parental. Por defeito, esta função está desativa."
                }
            ]
        },
        BASIC_PARENTAL_DEVICE: {
            TITLE: "Dispositivos sob Controlo Parental",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Exibe a lista de dispositivos sob Controlo Parental."
                }, {
                    type: "name",
                    title: "Nome de Dispositivo",
                    content: "Exibe o nome de todos os Dispositivos Clientes que estão atualmente sob Controlo Parental."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Exibe o endereço MAC de todos os Dispositivos Clientes que estão atualmente sob Controlo Parental."
                }, {
                    type: "name",
                    title: "Tempo de Acesso à Internet",
                    content: "Mostra os períodos de restrição de acesso à Internet."
                }, {
                    type: "name",
                    title: "DESCRIÇÃO",
                    content: "Mostra uma breve descrição do dispositivo ligado. É uma configuração opcional."
                }, {
                    type: "name",
                    title: "ESTADO",
                    content: "Exibe o estado atual (ativo ou desativo) do Controlo Parental do respetivo dispositivo."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Mostra opções para Modificar ou Apagar o dispositivo correspondente."
                }, {
                    type: "step",
                    title: "Para restringir um novo dispositivo cliente",
                    content: [
                        "1. Clique Adicionar.",
                        "2. Clique Ver Dispositivos Existentes e selecione um dispositivo ligado a partir da lista de Acesso de Dispositivos. Em alternativa introduza o nome e o endereço MAC manualmente para adicionar um dispositivo que não está ligado.",
                        "3. Clique no ícone de Tempo de Acesso à Internet para especificar um período de tempo durante o qual são aplicadas as restrições.",
                        "4. Insira uma breve descrição no campo Descrição. (Opcional)",
                        "5. Selecione Ativar.",
                        "6. Clique em OK para gravar esta entrada."
                    ]
                }, {
                    type: "paragraph",
                    content: "Para modificar ou eliminar uma entrada de Controlo Parental, clique simplesmente no ícone Modificar para editar a informação ou no ícone Apagar para remover a entrada correspondente."
                }, {
                    type: "paragraph",
                    content: "Para apagar várias entradas, selecione todas as entradas e clique em Apagar acima da tabela."
                }
            ]
        },
        BASIC_GUEST_NETWORK: {
            TITLE: "Rede de Convidados",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A Rede de Convidados permite criar uma rede Wi-Fi isolada, com um nome de rede (SSID) e senha diferentes, possibilitando aos seus convidados e amigos acesso à Internet sem terem acesso à sua rede local e logo sem comprometer a segurança da sua informação "
                }, {
                    type: "name",
                    title: "Permitir que convidados se vejam entre si",
                    content: "Selecione esta opção para permitir que os dispositivos Wi-Fi da Rede de Convidados possam comunicar entre si."
                }, {
                    type: "name",
                    title: "Não permitir que convidados possam gerir a minha rede.",
                    content: "Selecione esta opção para prevenir que os convidados possam iniciar a sessão na página de gestão."
                }, {
                    type: "name",
                    title: "Ativar Rede de Convidados",
                    content: "Selecione esta caixa de opção para ativar a rede de Convidados 2.4GHz/5GHz."
                }, {
                    type: "name",
                    title: "Nome de Rede Wi-Fi (SSID)",
                    content: "Utilize o SSID predefinido ou crie um novo nome  de rede Wi-Fi (até 32 caracteres)."
                }, {
                    type: "name",
                    title: "Ocultar SSID",
                    content: "Selecione esta opção se desejar esconder o SSID da Rede de Convidados das listas de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Senha",
                    content: "Crie uma senha com 8 a 63 caracteres ASCII, ou entre 8 e 64 caracteres hexadecimais (0-9, a-f, A-F), por forma a proteger a rede de Convidados."
                }
            ]
        },
        "": ""
    };
})(jQuery);
